/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.ShroomloinEntity;
import org.infernalstudios.infernalexp.entities.ai.TeleportPanicGoal;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class WarpbeetleEntity
extends PathfinderMob {
    private int attackTimer;
    private int conversionTicks;
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(ShroomloinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CHORUS = SynchedEntityData.m_135353_(WarpbeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float shellRotationMultiplier = 0.0f;
    public static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41954_, ((Block)IEBlocks.CRIMSON_FUNGUS_CAP.get()).m_5456_()});

    public WarpbeetleEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(1, (Goal)new TeleportPanicGoal(this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 0.6, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        if (InfernalExpansionConfig.MobInteractions.SPIDER_ATTACK_WARPBEETLE.getBoolean()) {
            this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, true, false));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CONVERTING, (Object)false);
        this.f_19804_.m_135372_(CHORUS, (Object)false);
    }

    public boolean isConverting() {
        return (Boolean)this.f_19804_.m_135370_(CONVERTING);
    }

    public void setConverting(boolean converting) {
        this.f_19804_.m_135381_(CONVERTING, (Object)converting);
    }

    public boolean isShaking() {
        return this.isConverting();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("chorus", this.isChorus());
        compound.m_128405_("WarpbeetleConversionTime", this.isConverting() ? this.conversionTicks : -1);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setChorus(compound.m_128471_("chorus"));
    }

    public boolean isChorus() {
        return (Boolean)this.f_19804_.m_135370_(CHORUS);
    }

    public void setChorus(boolean chorus) {
        this.f_19804_.m_135381_(CHORUS, (Object)chorus);
    }

    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (this.isConverting()) {
            return InteractionResult.FAIL;
        }
        if (!this.isChorus() && stack.m_41720_() == Items.f_42730_) {
            this.conversionTicks = 40;
            this.setConverting(true);
            if (!playerIn.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isChorus() && stack.m_41720_() == Items.f_41955_) {
            this.conversionTicks = 40;
            this.setConverting(true);
            if (!playerIn.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(playerIn, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.m_6084_() && this.isConverting() && this.conversionTicks > 0) {
            --this.conversionTicks;
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
            if (this.conversionTicks == 0) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.4);
                this.setChorus(!this.isChorus());
                this.setConverting(false);
            }
        }
        Vec3 vector3d = this.m_20184_();
        if (!this.f_19861_ && vector3d.f_82480_ < 0.0) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
    }

    public boolean m_7327_(Entity entityIn) {
        this.attackTimer = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.nextInt((int)f) : f;
        float f2 = (float)this.m_21133_(Attributes.f_22282_);
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f1);
        if (flag) {
            ((LivingEntity)entityIn).m_147240_((double)(f2 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 2.5, 1.0));
            this.m_19970_((LivingEntity)this, entityIn);
        }
        this.m_5496_((SoundEvent)IESoundEvents.WARPBEETLE_HURT.get(), 1.0f, 1.0f);
        return flag;
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(4);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IESoundEvents.WARPBEETLE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.WARPBEETLE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.WARPBEETLE_HURT.get();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }
}

