/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEItems;

public class IELootModifiers {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"infernalexp");
    public static final RegistryObject<GlobalLootModifierSerializer<HoglinLootModifier>> HOGLIN_LOOT_MODIFIER = LOOT_MODIFIERS.register("hoglin_loot_modifier", HoglinLootSerializer::new);

    public static void register(IEventBus eventBus) {
        LOOT_MODIFIERS.register(eventBus);
        InfernalExpansion.LOGGER.info("Infernal Expansion: Loot Modifiers Registered!");
    }

    private static class HoglinLootSerializer
    extends GlobalLootModifierSerializer<HoglinLootModifier> {
        private HoglinLootSerializer() {
        }

        public HoglinLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditionsIn) {
            return new HoglinLootModifier(conditionsIn);
        }

        public JsonObject write(HoglinLootModifier instance) {
            return null;
        }
    }

    private static class HoglinLootModifier
    extends LootModifier {
        protected HoglinLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (!InfernalExpansionConfig.MobInteractions.USE_HOGCHOPS.getBoolean()) {
                return generatedLoot;
            }
            generatedLoot.removeIf(stack -> stack.m_150930_(Items.f_42485_));
            generatedLoot.removeIf(stack -> stack.m_150930_(Items.f_42486_));
            if (context.m_78933_().nextDouble() < 0.7) {
                return generatedLoot;
            }
            int numChops = -1;
            int numCookedChops = -1;
            for (ItemStack item : generatedLoot) {
                if (item.m_41656_(Items.f_42485_.m_7968_())) {
                    numChops += item.m_41613_();
                    continue;
                }
                if (!item.m_41656_(Items.f_42486_.m_7968_())) continue;
                numCookedChops += item.m_41613_();
            }
            generatedLoot.add(new ItemStack((ItemLike)IEItems.COOKED_HOGCHOP.get(), Math.max(numCookedChops, 0)));
            generatedLoot.add(new ItemStack((ItemLike)IEItems.RAW_HOGCHOP.get(), Math.max(numChops, 1)));
            return generatedLoot;
        }
    }
}

