/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.LazyOptional;
import org.infernalstudios.infernalexp.capabilities.IWhipUpdate;
import org.infernalstudios.infernalexp.init.IECapabilities;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.network.IENetworkHandler;
import org.infernalstudios.infernalexp.network.WhipReachPacket;

public class WhipItem
extends TieredItem
implements Vanishable {
    private final float attackDamage;
    private final float attackSpeed;
    private LazyOptional<IWhipUpdate> whipUpdate = LazyOptional.empty();

    public WhipItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        this.attackSpeed = attackSpeedIn;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("\u00a76Hold right click to charge, then when fully charged, release to strike!"));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            if (itemStack.m_150930_((Item)IEItems.KINETIC_TONGUE_WHIP.get())) {
                itemStack.m_41663_(Enchantments.f_44980_, 3);
            }
            items.add((Object)itemStack);
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            this.setCharging(stack, false);
            int ticksSinceStart = this.m_8105_(stack) - timeLeft;
            if (ticksSinceStart < 0 || this.getTicksSinceAttack(stack) < 15) {
                this.setTicksSinceAttack(stack, 0);
                return;
            }
            this.setAttacking(stack, true);
            this.setTicksSinceAttack(stack, 18);
            worldIn.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (player.m_21187_().nextFloat() * 0.4f + 1.2f));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!worldIn.m_5776_()) {
                IENetworkHandler.sendToServer(new WhipReachPacket(player.m_142081_()));
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (handIn.equals((Object)InteractionHand.MAIN_HAND)) {
            playerIn.m_6672_(handIn);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (this.getAttacking(stack)) {
            this.setTicksSinceAttack(stack, 0);
            this.setAttacking(stack, false);
        }
        this.setCharging(stack, true);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (this.getCharging(stack) && this.getTicksSinceAttack(stack) <= 15 || this.getAttacking(stack)) {
            this.setTicksSinceAttack(stack, this.getTicksSinceAttack(stack) + 1);
        }
        if (this.getTicksSinceAttack(stack) >= 30 || !isSelected && entity instanceof Player && (player = (Player)entity).m_21206_() != stack) {
            this.setTicksSinceAttack(stack, 0);
            this.setAttacking(stack, false);
            this.setCharging(stack, false);
        }
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.m_7579_(stack, target, attacker);
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        Material material = state.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !state.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
        attributeBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        attributeBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        ImmutableMultimap attributes = attributeBuilder.build();
        return equipmentSlot == EquipmentSlot.MAINHAND ? attributes : super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    private LazyOptional<IWhipUpdate> getWhipUpdate(ItemStack itemStack) {
        if (!this.whipUpdate.isPresent()) {
            this.whipUpdate = itemStack.getCapability(IECapabilities.WHIP_UPDATE);
            this.whipUpdate.addListener(self -> LazyOptional.empty());
        }
        return this.whipUpdate;
    }

    public void setTicksSinceAttack(ItemStack itemStack, int ticksSinceAttack) {
        this.getWhipUpdate(itemStack).ifPresent(whipUpdate -> whipUpdate.setTicksSinceAttack(ticksSinceAttack));
    }

    public int getTicksSinceAttack(ItemStack itemStack) {
        IWhipUpdate whipUpdate = (IWhipUpdate)this.getWhipUpdate(itemStack).orElse(null);
        return whipUpdate == null ? 0 : whipUpdate.getTicksSinceAttack();
    }

    public void setAttacking(ItemStack itemStack, boolean attacking) {
        this.getWhipUpdate(itemStack).ifPresent(whipUpdate -> whipUpdate.setAttacking(attacking));
    }

    public boolean getAttacking(ItemStack itemStack) {
        IWhipUpdate whipUpdate = (IWhipUpdate)this.getWhipUpdate(itemStack).orElse(null);
        return whipUpdate != null && whipUpdate.getAttacking();
    }

    public void setCharging(ItemStack itemStack, boolean charging) {
        this.getWhipUpdate(itemStack).ifPresent(whipUpdate -> whipUpdate.setCharging(charging));
    }

    public boolean getCharging(ItemStack itemStack) {
        IWhipUpdate whipUpdate = (IWhipUpdate)this.getWhipUpdate(itemStack).orElse(null);
        return whipUpdate != null && whipUpdate.getCharging();
    }
}

