/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.access.AbstractArrowEntityAccess;
import org.infernalstudios.infernalexp.client.DynamicLightingHandler;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class MixinAbstractArrowEntity
implements AbstractArrowEntityAccess {
    @Unique
    private static final EntityDataAccessor<Boolean> GLOW = SynchedEntityData.m_135353_(AbstractArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> LUMINOUS = SynchedEntityData.m_135353_(AbstractArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> INFECTION = SynchedEntityData.m_135353_(AbstractArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> INFECTED_SOURCE = SynchedEntityData.m_135353_(AbstractArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void arrowTickInfernalExpansion(CallbackInfo ci) {
        DynamicLightingHandler.tick((AbstractArrow)this);
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData"})
    private void registerDataInfernalExpansion(CallbackInfo ci) {
        ((AbstractArrow)this).m_20088_().m_135372_(LUMINOUS, (Object)false);
        ((AbstractArrow)this).m_20088_().m_135372_(INFECTION, (Object)false);
        ((AbstractArrow)this).m_20088_().m_135372_(GLOW, (Object)false);
        ((AbstractArrow)this).m_20088_().m_135372_(INFECTED_SOURCE, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    private void writeAdditionalInfernalExpansion(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Luminous", ((Boolean)((AbstractArrow)this).m_20088_().m_135370_(LUMINOUS)).booleanValue());
        compound.m_128379_("Infection", ((Boolean)((AbstractArrow)this).m_20088_().m_135370_(INFECTION)).booleanValue());
        compound.m_128379_("Glow", ((Boolean)((AbstractArrow)this).m_20088_().m_135370_(GLOW)).booleanValue());
        compound.m_128379_("InfectedSource", ((Boolean)((AbstractArrow)this).m_20088_().m_135370_(INFECTED_SOURCE)).booleanValue());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    private void readAdditionalInfernalExpansion(CompoundTag compound, CallbackInfo ci) {
        this.setLuminous(compound.m_128471_("Luminous"));
        this.setInfection(compound.m_128471_("Infection"));
        this.setGlow(compound.m_128471_("Glow"));
        this.setInfectedSource(compound.m_128471_("InfectedSource"));
    }

    @Inject(at={@At(value="RETURN")}, method={"setOwner"})
    private void setShooterInfernalExpansion(Entity entityIn, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (entityIn instanceof LivingEntity && (livingEntity = (LivingEntity)entityIn).m_21023_((MobEffect)IEEffects.INFECTION.get())) {
            this.setInfectedSource(true);
            this.setInfection(true);
        }
    }

    @Override
    public boolean getLuminous() {
        return (Boolean)((AbstractArrow)this).m_20088_().m_135370_(LUMINOUS);
    }

    @Override
    public void setLuminous(boolean isLuminous) {
        ((AbstractArrow)this).m_20088_().m_135381_(LUMINOUS, (Object)isLuminous);
    }

    @Override
    public boolean getInfection() {
        return (Boolean)((AbstractArrow)this).m_20088_().m_135370_(INFECTION);
    }

    @Override
    public void setInfection(boolean isInfection) {
        ((AbstractArrow)this).m_20088_().m_135381_(INFECTION, (Object)isInfection);
    }

    @Override
    public boolean getInfectedSource() {
        return (Boolean)((AbstractArrow)this).m_20088_().m_135370_(INFECTED_SOURCE);
    }

    @Override
    public void setInfectedSource(boolean isInfectedSource) {
        ((AbstractArrow)this).m_20088_().m_135381_(INFECTED_SOURCE, (Object)isInfectedSource);
    }

    @Override
    public boolean getGlow() {
        return (Boolean)((AbstractArrow)this).m_20088_().m_135370_(GLOW);
    }

    @Override
    public void setGlow(boolean shouldGlow) {
        ((AbstractArrow)this).m_20088_().m_135381_(GLOW, (Object)shouldGlow);
    }
}

