/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import org.infernalstudios.infernalexp.access.AbstractArrowEntityAccess;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEParticleTypes;
import org.infernalstudios.infernalexp.init.IEPotions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Arrow.class})
public abstract class MixinArrowEntity {
    @Final
    @Shadow
    private Set<MobEffectInstance> f_36852_;
    @Shadow
    private Potion f_36855_;

    @Shadow
    protected abstract void m_36890_();

    @Inject(at={@At(value="RETURN")}, method={"setEffectsFromItem"})
    private void setPotionEffectInfernalExpansion(ItemStack stack, CallbackInfo ci) {
        if (this.f_36855_ == IEPotions.INFECTION.get() || this.f_36855_ == IEPotions.LONG_INFECTION.get() || this.f_36855_ == IEPotions.STRONG_INFECTION.get()) {
            ((AbstractArrowEntityAccess)((Object)this)).setInfection(true);
        } else if (this.f_36855_ == IEPotions.LUMINOUS.get() || this.f_36855_ == IEPotions.LONG_LUMINOUS.get() || this.f_36855_ == IEPotions.STRONG_LUMINOUS.get()) {
            ((AbstractArrowEntityAccess)((Object)this)).setLuminous(true);
        }
        this.m_36890_();
    }

    @Inject(at={@At(value="RETURN")}, method={"addEffect"})
    private void addEffectInfernalExpansion(MobEffectInstance effect, CallbackInfo ci) {
        for (MobEffectInstance effectInstance : this.f_36852_) {
            if (effectInstance.m_19544_() == IEEffects.INFECTION.get()) {
                ((AbstractArrowEntityAccess)((Object)this)).setInfection(true);
                continue;
            }
            if (effectInstance.m_19544_() != IEEffects.LUMINOUS.get()) continue;
            ((AbstractArrowEntityAccess)((Object)this)).setLuminous(true);
        }
        this.m_36890_();
    }

    @Inject(at={@At(value="HEAD")}, method={"makeParticle"})
    private void spawnCustomParticlesInfernalExpansion(int particleCount, CallbackInfo ci) {
        int j;
        if (((AbstractArrowEntityAccess)((Object)this)).getLuminous() || ((AbstractArrowEntityAccess)((Object)this)).getGlow()) {
            for (j = 0; j < particleCount; ++j) {
                ((Arrow)this).f_19853_.m_7106_((ParticleOptions)IEParticleTypes.GLOWSTONE_SPARKLE.get(), ((Arrow)this).m_20208_(0.5), ((Arrow)this).m_20187_(), ((Arrow)this).m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (((AbstractArrowEntityAccess)((Object)this)).getInfection()) {
            for (j = 0; j < particleCount; ++j) {
                ((Arrow)this).f_19853_.m_7106_((ParticleOptions)IEParticleTypes.INFECTION.get(), ((Arrow)this).m_20208_(0.5), ((Arrow)this).m_20187_(), ((Arrow)this).m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"doPostHurtEffects"})
    private void onArrowHitInfernalExpansion(LivingEntity living, CallbackInfo ci) {
        if (((AbstractArrowEntityAccess)((Object)this)).getGlow()) {
            living.m_7292_(new MobEffectInstance((MobEffect)IEEffects.LUMINOUS.get(), 3600));
        }
        if (((AbstractArrowEntityAccess)((Object)this)).getInfectedSource()) {
            living.m_7292_(new MobEffectInstance((MobEffect)IEEffects.INFECTION.get(), 600));
        }
    }
}

