/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.infernalstudios.infernalexp.access.FireTypeAccess;
import org.infernalstudios.infernalexp.api.FireType;
import org.infernalstudios.infernalexp.init.IEFireTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements FireTypeAccess {
    @Shadow
    @Final
    protected SynchedEntityData f_19804_;
    @Unique
    private static final EntityDataAccessor<String> FIRE_TYPE = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void IE_init(EntityType<?> entityTypeIn, Level worldIn, CallbackInfo ci) {
        this.f_19804_.m_135372_(FIRE_TYPE, (Object)IEFireTypes.FIRE.getName().toString());
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putShort(Ljava/lang/String;S)V", ordinal=0, shift=At.Shift.AFTER)})
    private void IE_writeCustomFires(CompoundTag tag, CallbackInfoReturnable<CompoundTag> ci) {
        tag.m_128359_("fireType", this.getFireType().getName().toString());
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;getShort(Ljava/lang/String;)S", ordinal=0, shift=At.Shift.AFTER)})
    private void IE_readCustomFires(CompoundTag tag, CallbackInfo ci) {
        this.setFireType(FireType.getOrDefault(new ResourceLocation(tag.m_128461_("fireType")), IEFireTypes.FIRE));
    }

    @Inject(method={"setSecondsOnFire"}, at={@At(value="HEAD")})
    private void IE_setToDefaultFireType(int seconds, CallbackInfo ci) {
        this.setFireType(IEFireTypes.FIRE);
    }

    @Override
    public FireType getFireType() {
        return FireType.getOrDefault(new ResourceLocation((String)this.f_19804_.m_135370_(FIRE_TYPE)), IEFireTypes.FIRE);
    }

    @Override
    public void setFireType(FireType type) {
        this.f_19804_.m_135381_(FIRE_TYPE, (Object)type.getName().toString());
    }
}

