/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.infernalstudios.infernalexp.entities.IBucketable;
import org.infernalstudios.infernalexp.init.IEItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Strider.class})
public abstract class MixinStriderEntity
extends Animal
implements ItemSteerable,
Saddleable,
IBucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Strider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    protected abstract void m_8097_();

    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    protected MixinStriderEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="HEAD")})
    private void IE_registerData(CallbackInfo info) {
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public boolean isFromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean isFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)isFromBucket);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void IE_writeAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("FromBucket", this.isFromBucket());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void IE_readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setFromBucket(compound.m_128471_("FromBucket"));
    }

    @Inject(method={"mobInteract"}, at={@At(value="RETURN")}, cancellable=true)
    public void IE_getEntityInteractionResult(Player playerIn, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult resultType = (InteractionResult)cir.getReturnValue();
        if (this.m_6162_()) {
            cir.setReturnValue((Object)IBucketable.tryBucketEntity(playerIn, hand, this).orElse(super.m_6071_(playerIn, hand)));
        } else {
            cir.setReturnValue((Object)resultType);
        }
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void IE_onInitialSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (reason == MobSpawnType.BUCKET) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(true);
            this.m_146762_(-24000);
            cir.setReturnValue((Object)spawnDataIn);
        }
    }

    @Override
    public void copyToStack(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        IBucketable.copyToStack((Mob)this, stack);
        compound.m_128405_("Age", this.m_146764_());
    }

    @Override
    public void copyFromAdditional(CompoundTag compound) {
        IBucketable.copyFromAdditional((Mob)this, compound);
        if (compound.m_128425_("Age", 99)) {
            this.m_146762_(compound.m_128451_("Age"));
        }
    }

    @Override
    public SoundEvent getBucketedSound() {
        return SoundEvents.f_11783_;
    }

    @Override
    public ItemStack getBucketItem() {
        return new ItemStack((ItemLike)IEItems.STRIDER_BUCKET.get());
    }
}

