/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.util;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public class CompatibilityQuark
implements ICondition {
    private final ResourceLocation resourceLocation;
    private final String flag;

    public CompatibilityQuark(ResourceLocation resourceLocation, String flag) {
        this.resourceLocation = resourceLocation;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.resourceLocation;
    }

    public boolean test() {
        if (ModList.get().isLoaded("quark")) {
            JsonObject jsonDummy = new JsonObject();
            jsonDummy.addProperty("type", "quark:flag");
            jsonDummy.addProperty("flag", this.flag);
            return CraftingHelper.getCondition((JsonObject)jsonDummy).test();
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<CompatibilityQuark> {
        private final ResourceLocation resourceLocation = new ResourceLocation("infernalexp", "quark_flag");

        public void write(JsonObject json, CompatibilityQuark value) {
            json.addProperty("flag", value.flag);
        }

        public CompatibilityQuark read(JsonObject json) {
            return new CompatibilityQuark(this.resourceLocation, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.resourceLocation;
        }
    }
}

