/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public class NetherTeleportCommandUtil {
    public static BlockPos getSafePosition(ServerLevel world, BlockPos pos) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.X);
        double shortestDistToOpen = -1.0;
        double shortestDistToFit = -1.0;
        BlockPos safePos = null;
        BlockPos tempPos = null;
        WorldBorder worldborder = world.m_6857_();
        int dimHeight = world.m_141928_();
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (BlockPos.MutableBlockPos currentPos : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int minDimHeight = Math.min(dimHeight - 1, world.m_6924_(Heightmap.Types.MOTION_BLOCKING, currentPos.m_123341_(), currentPos.m_123343_()));
            if (!worldborder.m_61937_((BlockPos)currentPos) || !worldborder.m_61937_((BlockPos)currentPos.m_122175_(direction, 1))) continue;
            currentPos.m_122175_(direction.m_122424_(), 1);
            for (int height = minDimHeight; height >= 0; --height) {
                int deltaHeight;
                currentPos.m_142448_(height);
                if (!world.m_46859_((BlockPos)currentPos)) continue;
                int currentHeight = height;
                while (height > 0 && world.m_46859_((BlockPos)currentPos.m_122173_(Direction.DOWN))) {
                    --height;
                }
                if (height + 4 > dimHeight - 1 || (deltaHeight = currentHeight - height) > 0 && deltaHeight < 3) continue;
                currentPos.m_142448_(height);
                if (!NetherTeleportCommandUtil.checkRegionForPlacement(world, (BlockPos)currentPos, mutablePos, direction, 0)) continue;
                double currentDist = pos.m_123331_((Vec3i)currentPos);
                if (NetherTeleportCommandUtil.checkRegionForPlacement(world, (BlockPos)currentPos, mutablePos, direction, -1) && NetherTeleportCommandUtil.checkRegionForPlacement(world, (BlockPos)currentPos, mutablePos, direction, 1) && (shortestDistToOpen == -1.0 || shortestDistToOpen > currentDist)) {
                    shortestDistToOpen = currentDist;
                    safePos = currentPos.m_7949_();
                }
                if (shortestDistToOpen != -1.0 || shortestDistToFit != -1.0 && !(shortestDistToFit > currentDist)) continue;
                shortestDistToFit = currentDist;
                tempPos = currentPos.m_7949_();
            }
        }
        if (shortestDistToOpen == -1.0 && shortestDistToFit != -1.0) {
            safePos = tempPos;
            shortestDistToOpen = shortestDistToFit;
        }
        if (shortestDistToOpen == -1.0 && !worldborder.m_61937_(safePos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)70, (int)(dimHeight - 10)), pos.m_123343_()).m_7949_())) {
            return null;
        }
        return safePos;
    }

    private static boolean checkRegionForPlacement(ServerLevel world, BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.m_122427_();
        for (int x = -1; x < 1; ++x) {
            for (int y = -1; y < 2; ++y) {
                offsetPos.m_122154_((Vec3i)originalPos, directionIn.m_122429_() * x + direction.m_122429_() * offsetScale, y, directionIn.m_122431_() * x + direction.m_122431_() * offsetScale);
                if (y < 0 && !world.m_8055_((BlockPos)offsetPos).m_60767_().m_76333_()) {
                    return false;
                }
                if (y < 0 || world.m_46859_((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

