/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.infernalstudios.infernalexp.blocks.PlantedQuartzBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.world.gen.features.IEFeature;
import org.infernalstudios.infernalexp.world.gen.features.config.PlantedQuartzFeatureConfig;

public class PlantedQuartzFeature
extends IEFeature<PlantedQuartzFeatureConfig> {
    private static final int MAX_AMOUNT = 15;

    public PlantedQuartzFeature(Codec<PlantedQuartzFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public boolean placeFeature(FeaturePlaceContext<PlantedQuartzFeatureConfig> context) {
        int amount = 0;
        for (int j = 0; j < 128; ++j) {
            int random = context.m_159776_().nextInt(6);
            BlockPos pos = context.m_159777_().m_142082_(context.m_159776_().nextInt(17) - 8, context.m_159776_().nextInt(9) - 4, context.m_159776_().nextInt(17) - 8);
            BlockState state = (BlockState)((PlantedQuartzBlock)((Object)IEBlocks.PLANTED_QUARTZ.get())).m_49966_().m_61124_((Property)PlantedQuartzBlock.f_53179_, (Comparable)AttachFace.values()[(Math.min(random, 2) + 2) % 3]);
            if (random >= 2) {
                state.m_61124_((Property)PlantedQuartzBlock.f_54117_, (Comparable)Direction.values()[random]);
            }
            if (!state.m_60710_((LevelReader)context.m_159774_(), pos)) continue;
            if (context.m_159774_().m_46859_(pos) && state.m_60710_((LevelReader)context.m_159774_(), pos)) {
                float chance = context.m_159776_().nextFloat();
                if (this.findOre(context.m_159774_(), pos) || chance > ((PlantedQuartzFeatureConfig)context.m_159778_()).chanceToFail) {
                    context.m_159774_().m_7731_(pos, state, 2);
                    ++amount;
                }
            }
            if (amount < 15) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean shouldPlaceOnStructures() {
        return true;
    }

    public boolean findOre(WorldGenLevel world, BlockPos pos) {
        int radius = 3;
        for (int x = pos.m_123341_() - 3; x < pos.m_123341_() + 3; ++x) {
            for (int y = pos.m_123342_() - 3; y < pos.m_123342_() + 3; ++y) {
                for (int z = pos.m_123343_() - 3; z < pos.m_123343_() + 3; ++z) {
                    if (!world.m_8055_(new BlockPos(x, y, z)).m_60734_().equals(Blocks.f_50331_)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

