/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class StructureUtil {
    public static Optional<Integer> getSuitableNetherYLevel(PieceGeneratorSupplier.Context<?> context, BlockPos pos) {
        NoiseColumn column = context.f_197352_().m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
        ArrayList<Integer> suitableYLevels = new ArrayList<Integer>();
        for (int y = 127; y > context.f_197352_().m_6337_(); --y) {
            if (!column.m_183556_(y - 1).m_60815_() || !column.m_183556_(y).m_60795_() || !column.m_183556_(y + 4).m_60795_()) continue;
            suitableYLevels.add(y);
        }
        if (suitableYLevels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Integer)suitableYLevels.get(new Random(context.f_197354_()).nextInt(suitableYLevels.size())));
    }

    public static Optional<Integer> getNetherLavaFloorY(PieceGeneratorSupplier.Context<?> context, BlockPos pos) {
        int y = context.f_197352_().m_6337_();
        NoiseColumn column = context.f_197352_().m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
        BlockPos lavaPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
        if (column.m_183556_(lavaPos.m_123342_()).m_60815_()) {
            return Optional.empty();
        }
        for (int topDown = 1; topDown <= y; ++topDown) {
            BlockState checkLava = column.m_183556_(lavaPos.m_123342_() - topDown);
            BlockState checkBlock = column.m_183556_(lavaPos.m_123342_() - topDown - 1);
            if (!checkLava.m_60713_(Blocks.f_49991_) || !checkBlock.m_60783_((BlockGetter)context.f_197357_(), pos.m_6625_(y), Direction.UP)) continue;
            return Optional.of(y - topDown);
        }
        return Optional.empty();
    }

    public static boolean checkLandAtHeight(PieceGeneratorSupplier.Context<?> context, BlockPos pos, int heightTolerance) {
        NoiseColumn column = context.f_197352_().m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
        for (int y = pos.m_123342_() - heightTolerance; y <= pos.m_123343_() + heightTolerance; ++y) {
            if (!column.m_183556_(y).m_60815_() || !column.m_183556_(y + 1).m_60795_()) continue;
            return true;
        }
        return false;
    }

    public static <T extends JigsawConfiguration> Optional<PieceGenerator<T>> addPieces(PieceGeneratorSupplier.Context<T> context, JigsawPlacement.PieceFactory pieceFactory, BlockPos pos, boolean usePosHeight) {
        return JigsawPlacement.m_210284_(context, (JigsawPlacement.PieceFactory)pieceFactory, (BlockPos)pos, (boolean)false, (boolean)usePosHeight).map(pieceGenerator -> pieceGenerator);
    }
}

