/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;

public class Spell
implements Cloneable {
    public static final Spell EMPTY = new Spell();
    public List<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
    private int cost;

    public Spell(List<AbstractSpellPart> recipe) {
        this.recipe = recipe == null ? new ArrayList() : recipe;
        this.cost = this.getInitialCost();
    }

    public Spell() {
    }

    public Spell(AbstractSpellPart ... spellParts) {
        this.add(spellParts);
    }

    public Spell add(AbstractSpellPart spellPart) {
        this.recipe.add(spellPart);
        return this;
    }

    public Spell add(AbstractSpellPart ... spellParts) {
        for (AbstractSpellPart part : spellParts) {
            this.add(part);
        }
        return this;
    }

    public Spell add(AbstractSpellPart spellPart, int count) {
        for (int i = 0; i < count; ++i) {
            this.recipe.add(spellPart);
        }
        return this;
    }

    public int getSpellSize() {
        return this.recipe.size();
    }

    @Nullable
    public AbstractCastMethod getCastMethod() {
        if (this.recipe == null || this.recipe.isEmpty()) {
            return null;
        }
        return this.recipe.get(0) instanceof AbstractCastMethod ? (AbstractCastMethod)this.recipe.get(0) : null;
    }

    public List<AbstractAugment> getAugments(int startPosition, @Nullable LivingEntity caster) {
        AbstractSpellPart next_spell;
        ArrayList<AbstractAugment> augments = new ArrayList<AbstractAugment>();
        if (this.recipe == null || this.recipe.isEmpty()) {
            return augments;
        }
        for (int j = startPosition + 1; j < this.recipe.size() && (next_spell = this.recipe.get(j)) instanceof AbstractAugment; ++j) {
            augments.add((AbstractAugment)next_spell);
        }
        return augments;
    }

    public int getInstanceCount(AbstractSpellPart spellPart) {
        int count = 0;
        for (AbstractSpellPart abstractSpellPart : this.recipe) {
            if (!abstractSpellPart.equals(spellPart)) continue;
            ++count;
        }
        return count;
    }

    public int getBuffsAtIndex(int startPosition, @Nullable LivingEntity caster, AbstractAugment augment) {
        return (int)this.getAugments(startPosition, caster).stream().filter(a -> a.equals(augment)).count();
    }

    private int getInitialCost() {
        int cost = 0;
        if (this.recipe == null) {
            return cost;
        }
        for (AbstractSpellPart spell : this.recipe) {
            cost += spell.getConfigCost();
        }
        return Math.max(0, cost);
    }

    public int getCastingCost() {
        return Math.max(0, this.cost);
    }

    public void setCost(int cost) {
        this.cost = Math.max(0, cost);
    }

    public boolean isEmpty() {
        return this.recipe == null || this.recipe.isEmpty();
    }

    public String serialize() {
        ArrayList<String> tags = new ArrayList<String>();
        for (AbstractSpellPart slot : this.recipe) {
            tags.add(slot.getId());
        }
        return ((Object)tags).toString();
    }

    public static Spell deserialize(String recipeStr) {
        String[] recipeList;
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        if (recipeStr.length() <= 3) {
            return new Spell(recipe);
        }
        for (String id : recipeList = recipeStr.substring(1, recipeStr.length() - 1).split(",")) {
            if (!ArsNouveauAPI.getInstance().getSpellpartMap().containsKey(id.trim())) continue;
            recipe.add(ArsNouveauAPI.getInstance().getSpellpartMap().get(id.trim()));
        }
        return new Spell(recipe);
    }

    public String getDisplayString() {
        StringBuilder str = new StringBuilder();
        String lastStr = "";
        for (int i = 0; i < this.recipe.size(); ++i) {
            AbstractSpellPart spellPart = this.recipe.get(i);
            int num = 1;
            for (int j = i + 1; j < this.recipe.size() && spellPart.name.equals(this.recipe.get((int)j).name); ++j) {
                ++num;
            }
            if (num > 1) {
                str.append(spellPart.getLocaleName()).append(" x").append(num);
                i += num - 1;
            } else {
                str.append(spellPart.getLocaleName());
            }
            if (i >= this.recipe.size() - 1) continue;
            str.append(" -> ");
        }
        return str.toString();
    }

    public boolean isValid() {
        return !this.isEmpty();
    }

    public Spell clone() {
        try {
            Spell clone = (Spell)super.clone();
            clone.recipe = new ArrayList<AbstractSpellPart>(this.recipe);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static class Builder {
        private Spell spell = new Spell();

        public Builder add(AbstractSpellPart spellPart) {
            this.spell.add(spellPart);
            return this;
        }

        public Builder add(AbstractSpellPart spellPart, int count) {
            for (int i = 0; i < count; ++i) {
                this.spell.add(spellPart);
            }
            return this;
        }

        public Spell build() {
            return this.spell;
        }
    }
}

