/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantmentRecipe;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class EnchantmentProcessor
implements IComponentProcessor {
    EnchantmentRecipe recipe;

    public void setup(IVariableProvider variables) {
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        String recipeID = variables.get("recipe").asString();
        this.recipe = manager.m_44043_(new ResourceLocation(recipeID)).orElse(null);
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("enchantment")) {
            return IVariable.wrap((String)this.recipe.enchantment.m_44704_());
        }
        if (key.equals("level")) {
            return IVariable.wrap((Number)this.recipe.enchantLevel);
        }
        if (key.startsWith("item")) {
            int index = Integer.parseInt(key.substring(4)) - 1;
            if (this.recipe.pedestalItems.size() <= index) {
                return IVariable.from((Object)ItemStack.f_41583_);
            }
            Ingredient ingredient = (Ingredient)this.recipe.pedestalItems.get(Integer.parseInt(key.substring(4)) - 1);
            return IVariable.wrapList((Iterable)Arrays.asList(ingredient.m_43908_()).stream().map(IVariable::from).collect(Collectors.toList()));
        }
        return null;
    }
}

