/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class AnimatedAttackGoal
extends Goal {
    protected final Mob mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    public int timeAnimating = 0;
    public boolean arrived = false;
    public boolean done = false;
    public Supplier<Boolean> canAttack;
    int animationID;
    int animationLength;
    int attackRange;

    public AnimatedAttackGoal(Mob entity, boolean followUnseen, Supplier<Boolean> canAttack, int animationID, int animationLength, int attackRange, double speedModifier) {
        this.mob = entity;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followUnseen;
        this.canAttack = canAttack;
        this.animationID = animationID;
        this.animationLength = animationLength;
        this.attackRange = attackRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return true;
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (!this.canAttack.get().booleanValue()) {
            return false;
        }
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!this.canAttack.get().booleanValue()) {
            return false;
        }
        if (livingentity == null || this.done) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.timeAnimating = 0;
        this.arrived = false;
        this.done = false;
    }

    public void m_8041_() {
    }

    public void arrivedTick() {
        ++this.timeAnimating;
        if (this.timeAnimating >= this.animationLength) {
            if (this.mob.m_5448_() != null) {
                this.attack(this.mob.m_5448_());
            }
            this.done = true;
        }
    }

    public void look(LivingEntity entity) {
        if (entity != null) {
            this.mob.m_21563_().m_24960_((Entity)entity, 30.0f, 30.0f);
        }
    }

    public void onArrive() {
        this.arrived = true;
        Networking.sendToNearby(this.mob.f_19853_, (Entity)this.mob, (Object)new PacketAnimEntity(this.mob.m_142049_(), this.animationID));
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        this.look(livingentity);
        if (this.arrived) {
            this.arrivedTick();
            return;
        }
        double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (BlockUtil.distanceFrom(this.mob.f_19825_, livingentity.f_19825_) <= (double)this.attackRange) {
            this.onArrive();
        }
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void attack(LivingEntity target) {
        if (BlockUtil.distanceFrom(target.f_19825_, this.mob.f_19825_) <= (double)this.attackRange) {
            this.ticksUntilNextAttack = 20;
            this.mob.m_7327_((Entity)target);
        }
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + p_179512_1_.m_20205_();
    }
}

