/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestClusterGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    int tickTime;
    boolean isDone;
    List<BlockPos> harvestableList = new ArrayList<BlockPos>();

    public HarvestClusterGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public void m_8037_() {
        super.m_8037_();
        --this.tickTime;
        this.golem.getNavigation().m_26573_();
        if (this.tickTime % 40 == 0) {
            this.tryDropAmethyst();
        }
        if (this.tickTime <= 0 || this.harvestableList.isEmpty()) {
            this.isDone = true;
            this.golem.setStomping(false);
            this.golem.harvestCooldown = 1200;
        }
    }

    public void tryDropAmethyst() {
        ArrayList<BlockPos> harvested = new ArrayList<BlockPos>();
        for (BlockPos p : this.harvestableList) {
            if (!this.hasCluster(p)) continue;
            harvested.add(p);
            this.harvest(p);
            break;
        }
        for (BlockPos p : harvested) {
            this.harvestableList.remove(p);
        }
    }

    public void harvest(BlockPos p) {
        Direction[] directionArray = this.golem.f_19853_;
        if (!(directionArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)directionArray;
        for (Direction d : Direction.values()) {
            BlockPos clusterPos = p.m_142300_(d);
            BlockState state = level.m_8055_(clusterPos);
            if (!state.m_204336_(BlockTagProvider.CLUSTER_BLOCKS)) continue;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42390_);
            state.m_60734_().m_6240_((Level)level, (Player)ANFakePlayer.getPlayer(level), clusterPos, state, level.m_7702_(p), stack);
            BlockUtil.destroyBlockSafely((Level)level, clusterPos, false, (LivingEntity)ANFakePlayer.getPlayer(level));
        }
    }

    public boolean hasCluster(BlockPos p) {
        for (Direction d : Direction.values()) {
            if (!this.golem.f_19853_.m_8055_(p.m_142300_(d)).m_204336_(BlockTagProvider.CLUSTER_BLOCKS)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.golem.setStomping(true);
        this.golem.getNavigation().m_26573_();
        this.isDone = false;
        this.harvestableList = new ArrayList<BlockPos>(this.golem.buddingBlocks);
        Collections.shuffle(this.harvestableList);
        this.tickTime = 130;
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.HARVEST;
    }

    public void m_8041_() {
        this.golem.setStomping(false);
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
    }

    public boolean m_8045_() {
        return !this.isDone;
    }

    public boolean m_8036_() {
        return this.canUse.get() != false && !this.golem.buddingBlocks.isEmpty();
    }
}

