/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import net.minecraft.core.BlockPos;

public class ModNode
implements Comparable<ModNode> {
    private static final int HASH_A = 12;
    private static final int HASH_B = 20;
    private static final int HASH_C = 24;
    public final BlockPos pos;
    private final int hash;
    public ModNode parent;
    private int counterAdded;
    private int counterVisited;
    private int steps;
    private double cost;
    private double heuristic;
    private double score;
    private boolean closed = false;
    private boolean ladder = false;
    private boolean swimming = false;
    private boolean isOnRails = false;
    private boolean isCornerNode = false;
    private boolean isReachedByWorker = false;

    public ModNode(BlockPos pos, double heuristic) {
        this(null, pos, 0.0, heuristic, heuristic);
    }

    public ModNode(ModNode parent, BlockPos pos, double cost, double heuristic, double score) {
        this.parent = parent;
        this.pos = pos;
        this.steps = parent == null ? 0 : parent.steps + 1;
        this.cost = cost;
        this.heuristic = heuristic;
        this.score = score;
        this.hash = pos.m_123341_() ^ (pos.m_123343_() << 12 | pos.m_123343_() >> 20) ^ pos.m_123342_() << 24;
    }

    @Override
    public int compareTo(ModNode o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            ModNode other = (ModNode)o;
            return this.pos.m_123341_() == other.pos.m_123341_() && this.pos.m_123342_() == other.pos.m_123342_() && this.pos.m_123343_() == other.pos.m_123343_();
        }
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLadder() {
        return this.ladder;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void setClosed() {
        this.closed = true;
    }

    public int getCounterVisited() {
        return this.counterVisited;
    }

    public void setCounterVisited(int counterVisited) {
        this.counterVisited = counterVisited;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public void setLadder() {
        this.ladder = true;
    }

    public void setSwimming() {
        this.swimming = true;
    }

    public double getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(double heuristic) {
        this.heuristic = heuristic;
    }

    public int getCounterAdded() {
        return this.counterAdded;
    }

    public void setCounterAdded(int counterAdded) {
        this.counterAdded = counterAdded;
    }

    public void setOnRails(boolean isOnRails) {
        this.isOnRails = isOnRails;
    }

    public boolean isOnRails() {
        return this.isOnRails;
    }

    public void setReachedByWorker(boolean reached) {
        this.isReachedByWorker = reached;
    }

    public boolean isReachedByWorker() {
        return this.isReachedByWorker;
    }

    public void setCornerNode(boolean isCornerNode) {
        this.isCornerNode = isCornerNode;
    }

    public boolean isCornerNode() {
        return this.isCornerNode;
    }
}

