/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public abstract class PotionFlask
extends ModItem {
    public PotionFlask() {
        super(ItemsRegistry.defaultItemProperties().m_41487_(1));
        this.setRegistryName("potion_flask");
    }

    public PotionFlask(Item.Properties props, String registryName) {
        super(props);
        this.setRegistryName(registryName);
    }

    public PotionFlask(String registryName) {
        super(ItemsRegistry.defaultItemProperties().m_41487_(1));
        this.setRegistryName(registryName);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return super.m_6225_(context);
        }
        ItemStack thisStack = context.m_43722_();
        Potion potion = PotionUtils.m_43579_((ItemStack)thisStack);
        Player playerEntity = context.m_43723_();
        if (!(context.m_43725_().m_7702_(context.m_8083_()) instanceof PotionJarTile)) {
            return super.m_6225_(context);
        }
        PotionJarTile jarTile = (PotionJarTile)context.m_43725_().m_7702_(context.m_8083_());
        int count = thisStack.m_41783_().m_128451_("count");
        if (jarTile == null) {
            return InteractionResult.PASS;
        }
        if (playerEntity.m_6144_() && potion != Potions.f_43598_ && count > 0 && jarTile.getMaxFill() - jarTile.getCurrentFill() >= 0 && (jarTile.getPotion() == Potions.f_43598_ || jarTile.isMixEqual(thisStack))) {
            if (jarTile.getPotion() == Potions.f_43598_) {
                jarTile.setPotion(potion, PotionUtils.m_43547_((ItemStack)thisStack));
            }
            jarTile.addAmount(100);
            thisStack.m_41783_().m_128405_("count", count - 1);
            this.setCount(thisStack, count - 1);
        }
        if (context.m_43725_().m_7702_(context.m_8083_()) instanceof PotionJarTile && !playerEntity.m_6144_() && !this.isMax(thisStack) && jarTile.getPotion() != Potions.f_43598_ && (jarTile.isMixEqual(thisStack) || potion == Potions.f_43598_) && jarTile.getAmount() >= 100) {
            if (potion == Potions.f_43598_) {
                PotionUtils.m_43549_((ItemStack)thisStack, (Potion)jarTile.getPotion());
                PotionUtils.m_43552_((ItemStack)thisStack, jarTile.getCustomEffects());
            }
            this.setCount(thisStack, 1 + count);
            jarTile.addAmount(-100);
        }
        return super.m_6225_(context);
    }

    public boolean isMax(ItemStack stack) {
        return stack.m_41784_().m_128451_("count") >= this.getMaxCapacity();
    }

    public int getMaxCapacity() {
        return 8;
    }

    public void setCount(ItemStack stack, int count) {
        stack.m_41783_().m_128405_("count", count);
        if (count <= 0) {
            PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43598_);
            stack.m_41783_().m_128473_("CustomPotionEffects");
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player playerentity;
        Player player = playerentity = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (playerentity instanceof ServerPlayer) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)playerentity, stack);
        }
        if (!worldIn.f_46443_) {
            for (MobEffectInstance effectinstance : PotionUtils.m_43547_((ItemStack)stack)) {
                if ((effectinstance = this.getEffectInstance(effectinstance)).m_19544_().m_8093_()) {
                    effectinstance.m_19544_().m_19461_((Entity)playerentity, (Entity)playerentity, entityLiving, effectinstance.m_19564_(), 1.0);
                    continue;
                }
                entityLiving.m_7292_(new MobEffectInstance(effectinstance));
            }
            if (stack.m_41782_()) {
                int count = stack.m_41783_().m_128451_("count") - 1;
                this.setCount(stack, count);
            }
        }
        return stack;
    }

    @Nonnull
    public abstract MobEffectInstance getEffectInstance(MobEffectInstance var1);

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_ && !stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return stack.m_41782_() && stack.m_41783_().m_128451_("count") > 0 ? ItemUtils.m_150959_((Level)worldIn, (Player)playerIn, (InteractionHand)handIn) : InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            tooltip.add((Component)new TranslatableComponent("ars_nouveau.flask.charges", new Object[]{stack.m_41783_().m_128451_("count")}));
            PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
        }
    }
}

