/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class VoidJar
extends ModItem
implements IScribeable {
    public VoidJar() {
        super(ItemsRegistry.defaultItemProperties().m_41487_(1), "void_jar");
    }

    public void toggleStatus(Player playerEntity, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128471_("on")) {
            tag.m_128379_("on", false);
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.off"));
        } else {
            tag.m_128379_("on", true);
            PortUtil.sendMessage((Entity)playerEntity, (Component)new TranslatableComponent("ars_nouveau.on"));
        }
    }

    public static boolean tryVoiding(Player player, ItemStack pickingUp) {
        NonNullList list = player.f_36093_.f_35974_;
        boolean voided = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack jar = (ItemStack)list.get(i);
            if (jar.m_41720_() != ItemsRegistry.VOID_JAR || !VoidJar.isActive(jar) || !ItemScroll.containsItem(pickingUp, jar.m_41783_())) continue;
            CapabilityRegistry.getMana((LivingEntity)player).ifPresent(iMana -> iMana.addMana(5.0 * (double)pickingUp.m_41613_()));
            pickingUp.m_41764_(0);
            voided = true;
            break;
        }
        return voided;
    }

    public static boolean isActive(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("on");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            return super.m_7203_(worldIn, player, handIn);
        }
        ItemStack stack = player.m_21120_(handIn);
        CompoundTag tag = stack.m_41784_();
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack stackToWrite = player.m_21206_();
            if (player.m_6144_()) {
                this.toggleStatus(player, stack);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (!stackToWrite.m_41619_()) {
                if (ItemScroll.containsItem(stackToWrite, tag)) {
                    PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.scribe.item_removed"));
                    ItemScroll.removeItem(stackToWrite, tag);
                    player.m_6672_(handIn);
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                PortUtil.sendMessage((Entity)player, (Component)new TranslatableComponent("ars_nouveau.scribe.item_added"));
                ItemScroll.addItem(stackToWrite, tag);
                player.m_6672_(handIn);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128471_("on")) {
            tooltip2.add((Component)new TranslatableComponent("ars_nouveau.on"));
        } else {
            tooltip2.add((Component)new TranslatableComponent("ars_nouveau.off"));
        }
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String string : tag.m_128431_()) {
            if (!string.contains(ItemScroll.ITEM_PREFIX)) continue;
            stacks.add(ItemStack.m_41712_((CompoundTag)tag.m_128469_(string)));
        }
        for (ItemStack itemStack : stacks) {
            tooltip2.add(itemStack.m_41786_());
        }
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        return ItemScroll.scribe(world, pos, player, handIn, thisStack);
    }
}

