/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class EffectPlaceBlock
extends AbstractEffect {
    public static EffectPlaceBlock INSTANCE = new EffectPlaceBlock();

    private EffectPlaceBlock() {
        super("place_block", "Place Block");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.m_82425_(), rayTraceResult, spellStats);
        BlockHitResult result = rayTraceResult;
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        block0: for (BlockPos pos1 : posList) {
            BlockPos affectedPos;
            Item direction;
            ItemStack stack;
            BlockPos hitPos;
            BlockPos blockPos = hitPos = result.m_82436_() ? pos1 : pos1.m_142300_(result.m_82434_());
            if (spellContext.castingTile instanceof IPlaceBlockResponder) {
                boolean isTouch;
                BlockState blockTargetted;
                stack = ((IPlaceBlockResponder)spellContext.castingTile).onPlaceBlock();
                if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) {
                    return;
                }
                BlockItem item = (BlockItem)stack.m_41720_();
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
                if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos1), world.m_8055_(pos1), (Entity)fakePlayer)) || (blockTargetted = (isTouch = spellContext.getSpell().recipe.get(0) instanceof MethodTouch) ? world.m_8055_(hitPos.m_142300_(result.m_82434_().m_122424_())) : world.m_8055_(hitPos.m_142300_(result.m_82434_()))).m_60767_() != Material.f_76296_) continue;
                direction = isTouch ? result.m_82434_().m_122424_() : result.m_82434_();
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, result)), (BlockPos)hitPos.m_142300_((Direction)direction), (Direction)direction);
                item.m_40576_(context);
                affectedPos = context.m_8083_();
                ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)affectedPos.m_123341_(), (double)affectedPos.m_123342_(), (double)affectedPos.m_123343_()), context.f_43705_.m_82434_(), affectedPos, false), world, shooter, spellContext, resolver);
                continue;
            }
            if (shooter instanceof IPlaceBlockResponder) {
                stack = ((IPlaceBlockResponder)shooter).onPlaceBlock();
                if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) {
                    return;
                }
                BlockItem item = (BlockItem)stack.m_41720_();
                if (world.m_8055_(hitPos).m_60767_() != Material.f_76296_) {
                    result = new BlockHitResult(result.m_82450_().m_82520_(0.0, 1.0, 0.0), Direction.UP, result.m_82425_(), false);
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos1), world.m_8055_(pos1), (Entity)shooter))) continue;
                EffectPlaceBlock.attemptPlace(world, stack, item, result, (Player)fakePlayer);
                continue;
            }
            if (!(shooter instanceof Player)) continue;
            Player playerEntity = (Player)shooter;
            NonNullList list = playerEntity.f_36093_.f_35974_;
            if (!world.m_8055_(hitPos).m_60767_().m_76336_() || MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos1), world.m_8055_(pos1), (Entity)playerEntity))) continue;
            for (int i = 0; i < 9; ++i) {
                BlockHitResult resolveResult;
                BlockItem blockItem;
                InteractionResult resultType;
                ItemStack stack2 = (ItemStack)list.get(i);
                direction = stack2.m_41720_();
                if (!(direction instanceof BlockItem) || InteractionResult.FAIL == (resultType = EffectPlaceBlock.attemptPlace(world, stack2, blockItem = (BlockItem)direction, resolveResult = new BlockHitResult(new Vec3((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_()), result.m_82434_(), hitPos, false), (Player)fakePlayer))) continue;
                affectedPos = resolveResult.m_82425_();
                ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)affectedPos.m_123341_(), (double)affectedPos.m_123342_(), (double)affectedPos.m_123343_()), resolveResult.m_82434_(), affectedPos, false), world, shooter, spellContext, resolver);
                continue block0;
            }
        }
    }

    @Override
    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return this.nonAirBlockSuccess(rayTraceResult, world);
    }

    public static InteractionResult attemptPlace(Level world, ItemStack stack, BlockItem item, BlockHitResult result, Player fakePlayer) {
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
        BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)new BlockPlaceContext(new UseOnContext(fakePlayer, InteractionHand.MAIN_HAND, result)), (BlockPos)result.m_82425_(), (Direction)result.m_82434_());
        return item.m_40576_(context);
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Places blocks from the casters inventory. If a player is casting this, this spell will place blocks from the hot bar first.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

