/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.registries.SkiesItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class FruitBlock
extends Block {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private Supplier<LeavesBlock> leaves;

    public FruitBlock(Supplier<LeavesBlock> leaves) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56736_));
        this.leaves = leaves;
    }

    public LeavesBlock getLeaves() {
        return this.leaves.get();
    }

    public boolean isOvercrowded(ServerLevel level, BlockPos pos) {
        int range = 7;
        int fruitsNear = 0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                for (int y = -range; y <= range; ++y) {
                    if (level.m_8055_(pos.m_142082_(x, y, z)).m_60734_() != this) continue;
                    ++fruitsNear;
                }
            }
        }
        return fruitsNear > 2;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(level, pos);
        return SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_60734_() == this.getLeaves();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(this.getRegistryName());
        return new ItemStack((ItemLike)(item != null ? item : SkiesItems.crescent_fruit));
    }
}

