/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.assets.BlueSkiesAssets;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalSearchScreen;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalSectionScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalNarratorButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalSectionButton;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.journal.JournalSection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class BlueJournalStartScreen
extends BlueJournalScreen {
    private static final String TAGLINE = "blue_skies.blue_journal.tagline";
    private static final String WELCOME = "blue_skies.blue_journal.welcome";
    private final List<List<JournalSectionButton>> sectionButtons = new ArrayList<List<JournalSectionButton>>();
    private final List<FormattedText> taglineLines = new ArrayList<FormattedText>();
    private final List<FormattedText> welcomeLines = new ArrayList<FormattedText>();
    private boolean sayUsageMessage = true;

    public BlueJournalStartScreen() {
        super(null);
    }

    @Override
    protected void loadData() {
        this.sectionButtons.clear();
        int x = this.f_96543_ / 2 + 145;
        ArrayList<JournalSectionButton> buttons = new ArrayList<JournalSectionButton>();
        buttons.add(new JournalSectionButton(x, 0, new JournalSection.Search(), button -> this.f_96541_.m_91152_((Screen)new BlueJournalSearchScreen(this, ((JournalSectionButton)button).section, (JournalSectionButton)button))));
        BlueSkiesData.JOURNAL_SECTIONS.getData().forEach((name, section) -> buttons.add(new JournalSectionButton(x, 0, (JournalSection)section, button -> Minecraft.m_91087_().m_91152_((Screen)new BlueJournalSectionScreen(this, (JournalSection)section, (JournalSectionButton)button)))));
        buttons.sort(JournalSectionButton::compareTo);
        int buttonsPerPage = 10;
        this.totalPages = buttons.size() / buttonsPerPage + (buttons.size() % buttonsPerPage == 0 ? 0 : 1);
        for (int i = 0; i < this.totalPages; ++i) {
            this.sectionButtons.add(buttons.subList(i * buttonsPerPage, Math.min(buttonsPerPage * (i + 1), buttons.size())));
        }
        this.totalPages *= 2;
        for (List<JournalSectionButton> btns : this.sectionButtons) {
            int y = this.f_96544_ / 2 - 120;
            for (JournalSectionButton b : btns) {
                b.f_93621_ = y += 20;
                this.m_142416_((GuiEventListener)b);
            }
        }
        this.taglineLines.clear();
        this.welcomeLines.clear();
        int lineWidth = 135;
        this.taglineLines.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)BlueSkiesAssets.JOURNAL_LANG.getTranslation(TAGLINE), lineWidth, Style.f_131099_));
        this.welcomeLines.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)BlueSkiesAssets.JOURNAL_LANG.getTranslation(WELCOME), lineWidth, Style.f_131099_));
        this.m_142416_((GuiEventListener)new JournalNarratorButton(this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 84, button -> JournalNarratorButton.narrate(Arrays.asList(this.taglineLines, this.welcomeLines))));
    }

    @Override
    protected boolean shouldSayUsageMessage() {
        if (this.sayUsageMessage) {
            this.sayUsageMessage = false;
            return true;
        }
        return false;
    }

    @Override
    protected void renderExtra(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.renderLogo(matrix);
        this.renderText(matrix);
    }

    protected void renderLogo(PoseStack matrix) {
        int size = 128;
        int x = this.f_96543_ / 2 - 145;
        int y = this.f_96544_ / 2 - 120;
        matrix.m_85836_();
        RenderSystem.m_69478_();
        SkiesClientUtil.bind(BlueSkies.locate("textures/gui/journal/logo_backdrop.png"));
        BlueJournalStartScreen.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        matrix.m_85849_();
        SkiesClientUtil.bind(BlueSkies.locate("textures/gui/journal/logo.png"));
        BlueJournalStartScreen.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
    }

    protected void renderText(PoseStack matrix) {
        int middleX = this.f_96543_ / 2;
        int middleY = this.f_96544_ / 2;
        int offset = 0;
        for (FormattedText t : this.taglineLines) {
            this.f_96547_.m_92889_(matrix, (Component)new TextComponent(t.getString()), (float)(middleX - 81 - this.f_96547_.m_92852_(t) / 2), (float)(middleY - 20 + (offset += 11)), 0);
        }
        offset = 0;
        for (FormattedText t : this.welcomeLines) {
            this.f_96547_.m_92889_(matrix, (Component)new TextComponent(t.getString()), (float)(middleX + 4), (float)(middleY - 105 + (offset += 11)), 0);
        }
    }

    @Override
    protected void onPageChange() {
        super.onPageChange();
        for (int i = 0; i < this.sectionButtons.size(); ++i) {
            boolean visible = i == this.page / 2;
            this.sectionButtons.get(i).forEach(b -> {
                b.f_93624_ = visible;
            });
        }
    }
}

