/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import com.legacy.blue_skies.data.objects.ToolHandleType;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolHandleTypeManager
extends SkiesSyncedDataManager<Item, ToolHandleType, ToolHandleTypeManager> {
    public boolean loaded = false;

    public ToolHandleTypeManager() {
        super(ToolHandleType.getDirectory());
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        super.apply(jsonMap, resourceManager, profiler);
        this.loaded = true;
    }

    @Override
    protected Pair<Item, ToolHandleType> parseJson(JsonObject json, ResourceLocation name) throws SkiesDataManager.RegistryObjectNotFoundException {
        Item stick = ToolHandleTypeManager.parseItem(json, "stick");
        float attackSpeed = GsonHelper.m_13820_((JsonObject)json, (String)"attack_speed", (float)ToolHandleType.DEFAULT.getAttackSpeedModifier());
        float projectileDamage = GsonHelper.m_13820_((JsonObject)json, (String)"projectile_damage", (float)ToolHandleType.DEFAULT.getProjectileDamageModifier());
        float durability = GsonHelper.m_13820_((JsonObject)json, (String)"durability", (float)ToolHandleType.DEFAULT.getDurabilityModifier());
        int color = GsonHelper.m_13824_((JsonObject)json, (String)"color", (int)ToolHandleType.DEFAULT.getColor());
        return Pair.of((Object)stick, (Object)new ToolHandleType(durability, attackSpeed, projectileDamage, stick, color));
    }

    public ToolHandleType getHandle(ResourceLocation itemName) {
        if (ForgeRegistries.ITEMS.containsKey(itemName)) {
            return this.getHandle((Item)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return ToolHandleType.DEFAULT;
    }

    public ToolHandleType getHandle(Item item) {
        if (this.hasHandle(item)) {
            return (ToolHandleType)this.getValue(item);
        }
        return ToolHandleType.DEFAULT;
    }

    public boolean hasHandle(Item item) {
        return this.getData().containsKey(item);
    }

    public boolean hasHandle(ResourceLocation itemName) {
        if (ForgeRegistries.ITEMS.containsKey(itemName)) {
            return this.hasHandle((Item)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return false;
    }

    @Override
    public ToolHandleTypeManager newInstance() {
        return new ToolHandleTypeManager();
    }

    @Override
    public Pair<CompoundTag, CompoundTag> entryToNbt(Item key, ToolHandleType value) {
        CompoundTag keyNbt = new CompoundTag();
        this.putItem(keyNbt, "0", key);
        CompoundTag valueNbt = new CompoundTag();
        this.putItem(valueNbt, "0", value.getStick());
        valueNbt.m_128350_("1", value.getAttackSpeedModifier());
        valueNbt.m_128350_("2", value.getDurabilityModifier());
        valueNbt.m_128350_("3", value.getProjectileDamageModifier());
        valueNbt.m_128405_("4", value.getColor());
        return Pair.of((Object)keyNbt, (Object)valueNbt);
    }

    @Override
    public Pair<Item, ToolHandleType> entryFromNbt(CompoundTag keyNbt, CompoundTag valueNbt) {
        Item key = this.getItem(keyNbt, "0");
        Item stick = this.getItem(valueNbt, "0");
        float attackSpeed = valueNbt.m_128457_("1");
        float durability = valueNbt.m_128457_("2");
        float projectileDamage = valueNbt.m_128457_("3");
        int color = valueNbt.m_128451_("4");
        return Pair.of((Object)key, (Object)new ToolHandleType(durability, attackSpeed, projectileDamage, stick, color));
    }
}

