/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.ai.NonCreatureAttackGoal;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NyctoflyEntity
extends FlyingMob
implements Enemy {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int idleTime;
    @OnlyIn(value=Dist.CLIENT)
    private SoundInstance flapSound;

    public NyctoflyEntity(EntityType<? extends NyctoflyEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
        this.m_20242_(true);
        this.f_21342_ = new AIMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new NonCreatureAttackGoal((Mob)this, 1.7f, true));
        this.f_21345_.m_25352_(5, (Goal)new NyctoRandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new NyctoLookAroundGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 40.0);
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        if (this.m_21525_()) {
            super.m_6478_(typeIn, Vec3.f_82478_);
        } else {
            super.m_6478_(typeIn, pos);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.playFlightSound();
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_204029_(FluidTags.f_13131_)) {
                this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 0.3);
                this.m_6469_(DamageSource.f_19312_, 1.0f);
            }
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                this.m_146870_();
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19861_) {
            this.f_19861_ = false;
        }
        if (this.m_5448_() != null) {
            if (!this.m_5448_().m_6084_() || !EntityUtil.CAN_ATTACK.test((Entity)this.m_5448_())) {
                this.m_6710_(null);
            }
            if (this.m_5448_() != null) {
                Vec3 targetEyes = this.m_5448_().m_20299_(1.0f);
                this.m_21566_().m_6849_(targetEyes.f_82479_, targetEyes.f_82480_, targetEyes.f_82481_, 1.0);
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 40.0f, 40.0f);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.idleTime = this.m_20184_().f_82479_ <= 1.0 && this.m_20184_().f_82481_ <= 1.0 && this.idleTime <= 100 ? ++this.idleTime : 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playFlightSound() {
        if (!this.m_20067_() && this.f_19853_.f_46443_) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (this.flapSound == null && !soundHandler.m_120403_(this.flapSound) || this.flapSound != null && !soundHandler.m_120403_(this.flapSound)) {
                this.flapSound = new MovingEntitySound((LivingEntity)this, SkiesSounds.ENTITY_NYCTOFLY_FLYING);
                soundHandler.m_120367_(this.flapSound);
            }
        }
    }

    public boolean m_7327_(Entity entityIn) {
        this.m_5496_(SkiesSounds.ENTITY_NYCTOFLY_BITE, 0.5f, 1.0f);
        return entityIn.m_6469_(EntityUtil.DamageSources.causeBiteDamage((Entity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_NYCTOFLY_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_NYCTOFLY_DEATH;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        boolean randomBoolean = this.f_19853_.m_46471_() ? true : this.f_19796_.nextBoolean();
        return randomBoolean && super.m_5545_(worldIn, spawnReasonIn);
    }

    public int m_5792_() {
        return 1;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.5f;
    }

    public boolean isNotColliding(double x, double y, double z, double radius) {
        double d0 = (x - this.m_20185_()) / radius;
        double d1 = (y - this.m_20186_()) / radius;
        double d2 = (z - this.m_20189_()) / radius;
        AABB axisalignedbb = this.m_142469_();
        int i = 1;
        while ((double)i < radius) {
            if (!this.f_19853_.m_45772_(axisalignedbb = axisalignedbb.m_82386_(d0, d1, d2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    class AIMoveControl
    extends MoveControl {
        private NyctoflyEntity nycto;

        public AIMoveControl(NyctoflyEntity bug) {
            super((Mob)bug);
            this.nycto = NyctoflyEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 difference = new Vec3(this.f_24975_ - this.nycto.m_20185_(), this.f_24976_ - this.nycto.m_20186_(), this.f_24977_ - this.nycto.m_20189_());
                double d0 = difference.m_82553_();
                if (d0 < this.nycto.m_142469_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.nycto.m_20256_(this.nycto.m_20184_().m_82490_(0.5));
                } else {
                    if (this.nycto.m_5448_() != null && this.nycto.m_5448_().m_204029_(FluidTags.f_13131_)) {
                        return;
                    }
                    this.nycto.m_20256_(this.nycto.m_20184_().m_82549_(difference.m_82490_(this.m_24999_() * 0.05 / d0)));
                    if (this.nycto.m_5448_() == null) {
                        this.nycto.m_146922_(-((float)Mth.m_14136_((double)this.nycto.m_20184_().f_82479_, (double)this.nycto.m_20184_().f_82481_)) * 57.295776f);
                        this.nycto.f_20883_ = this.nycto.m_146908_();
                        if (this.nycto.f_19863_ && this.nycto.f_19797_ > 100) {
                            this.m_6849_(difference.f_82479_, difference.f_82479_, difference.f_82481_, 1.0);
                        }
                        if (this.nycto.idleTime >= 300 || !this.nycto.isNotColliding(this.f_24975_, this.f_24976_, this.f_24977_, d0)) {
                            this.f_24981_ = MoveControl.Operation.WAIT;
                        }
                    } else {
                        double d4 = this.nycto.m_5448_().m_20185_() - this.nycto.m_20185_();
                        double d5 = this.nycto.m_5448_().m_20189_() - this.nycto.m_20189_();
                        this.nycto.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                        this.nycto.f_20883_ = this.nycto.m_146908_();
                    }
                }
            }
        }

        public double m_24999_() {
            if (this.nycto.m_5448_() != null && (double)this.nycto.m_20270_((Entity)this.nycto.m_5448_()) < 7.0) {
                return 0.6;
            }
            return 0.8;
        }
    }

    static class NyctoRandomFlyGoal
    extends Goal {
        private final NyctoflyEntity nycto;

        public NyctoRandomFlyGoal(NyctoflyEntity bug) {
            this.nycto = bug;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            if (this.nycto.m_5448_() != null) {
                return false;
            }
            MoveControl movementController = this.nycto.m_21566_();
            if (!movementController.m_24995_() && this.nycto.m_5448_() == null) {
                return true;
            }
            double d0 = movementController.m_25000_() - this.nycto.m_20185_();
            double d3 = d0 * d0 + (d1 = movementController.m_25001_() - this.nycto.m_20186_()) * d1 + (d2 = movementController.m_25002_() - this.nycto.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            double d2;
            double d1;
            Random random = this.nycto.m_21187_();
            double d0 = this.nycto.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (this.nycto.f_19853_.m_8055_(new BlockPos(d0, d1 = this.nycto.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f), d2 = this.nycto.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f))).m_60819_().m_76152_() == Fluids.f_76193_) {
                return;
            }
            if (d1 >= 100.0) {
                d1 = this.nycto.m_20186_() - (this.nycto.m_20186_() - 100.0 - (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f));
            }
            if (random.nextFloat() < 0.02f || !this.nycto.f_19853_.m_45772_(this.nycto.m_142469_().m_82400_(2.0))) {
                this.nycto.m_21566_().m_6849_(d0, d1, d2, 1.0);
            }
        }
    }

    static class NyctoLookAroundGoal
    extends Goal {
        private final NyctoflyEntity parentEntity;

        public NyctoLookAroundGoal(NyctoflyEntity bug) {
            this.parentEntity = bug;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 Vector3d = this.parentEntity.m_20184_();
                this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_)) * 57.295776f);
                this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
            } else {
                LivingEntity entitylivingbase = this.parentEntity.m_5448_();
                if ((double)entitylivingbase.m_20270_((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.m_20185_() - this.parentEntity.m_20185_();
                    double d2 = entitylivingbase.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
        }
    }
}

