/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.StrangeLightningEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class SummonerEntity
extends SkiesIllagerBossEntity {
    public static final Predicate<ArtificialGolemEntity> NOT_RANGED = golem -> !golem.isRanged() && !golem.playerSpawned();
    public static final Predicate<ArtificialGolemEntity> IS_RANGED = golem -> golem.isRanged() && !golem.playerSpawned();
    public boolean golemsChanged = false;

    public SummonerEntity(EntityType<? extends SummonerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SummonRangerGoal());
        this.f_21345_.m_25352_(5, (Goal)new SummonGolemGoal());
        this.f_21345_.m_25352_(5, (Goal)new SphereAttackGoal());
        this.f_21345_.m_25352_(6, (Goal)new RegenGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 350.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    @Override
    public double getBossHealth() {
        return 350.0 + (double)this.getExtraPlayers() * 200.0;
    }

    @Override
    public float getHealAmount() {
        return 40.0f;
    }

    @Override
    public int getDamageCap() {
        return 15;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_summoner;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.summoner_trophy;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19620_ || effect.m_19544_() == MobEffects.f_19597_ ? false : super.m_7301_(effect);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void healthParticles() {
        if (this.secondPhaseHealth()) {
            this.spawnParticles((ParticleOptions)SkiesParticles.BLUE_FLAME);
        } else {
            this.spawnParticles((ParticleOptions)ParticleTypes.f_123815_);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.secondPhaseHealth() && !this.golemsChanged) {
            for (ArtificialGolemEntity golems : this.getGolemsInDungeonArea()) {
                golems.m_5496_(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ACTIVATE, 0.7f, 1.0f);
                golems.setEnraged(true);
            }
            this.golemsChanged = true;
        } else if (!this.secondPhaseHealth() && this.golemsChanged) {
            for (ArtificialGolemEntity golems : this.getGolemsInDungeonArea()) {
                golems.m_5496_(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEACTIVATE, 0.7f, 1.0f);
                golems.setEnraged(false);
            }
            this.golemsChanged = false;
        }
    }

    @Override
    public Pair<DyeColor, DyeColor> getFireworkColors() {
        return Pair.of((Object)DyeColor.PURPLE, (Object)DyeColor.LIME);
    }

    @Override
    public void invulnerableTick() {
        if (this.f_19853_.f_46443_) {
            double d0 = 0.05;
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123815_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.5, 0.0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123815_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), d0, -0.4, d0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123815_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), d0, -0.4, -d0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123815_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), -d0, -0.4, d0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123815_, true, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), -d0, -0.4, -d0);
        }
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_SUMMONER_IDLE;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_SUMMONER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_SUMMONER_HURT;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f + 0.9f;
    }

    protected float m_6121_() {
        return 1.5f;
    }

    @Override
    public BlockState getFloorState() {
        return SkiesBlocks.turquoise_stonebrick.m_49966_();
    }

    @Override
    public BossEvent.BossBarColor getBossBarColor() {
        return BossEvent.BossBarColor.PURPLE;
    }

    public SoundEvent m_7930_() {
        return SkiesSounds.ENTITY_SUMMONER_CELEBRATE;
    }

    protected SoundEvent m_7894_() {
        return SkiesSounds.ENTITY_SUMMONER_CAST_SPELL;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.BLINDING;
    }

    @Override
    public int getProgression() {
        return 1;
    }

    @Override
    public boolean isEverbrightBoss() {
        return true;
    }

    public List<ArtificialGolemEntity> getGolemsInDungeonArea() {
        if (this.getHome() == null) {
            return Lists.newArrayList();
        }
        return this.f_19853_.m_6443_(ArtificialGolemEntity.class, new AABB(this.getHome()).m_82377_(35.0, 15.0, 35.0), NOT_RANGED);
    }

    public List<ArtificialGolemEntity> getRangedGolemsInDungeonArea() {
        if (this.getHome() == null) {
            return Lists.newArrayList();
        }
        return this.f_19853_.m_6443_(ArtificialGolemEntity.class, new AABB(this.getHome()).m_82377_(35.0, 15.0, 35.0), IS_RANGED);
    }

    public int getMaxGolemsBasedOnPlayerCount() {
        return (this.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 4 : 3) + Math.min(4, this.getExtraPlayers());
    }

    class SummonRangerGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        private SummonRangerGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        @Override
        public boolean m_8036_() {
            List<ArtificialGolemEntity> golems = this.boss.getGolemsInDungeonArea();
            List<ArtificialGolemEntity> archers = this.boss.getRangedGolemsInDungeonArea();
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && archers.isEmpty() && golems.size() <= 1;
        }

        protected int m_8089_() {
            return 100;
        }

        protected int m_8067_() {
            return 340;
        }

        protected void m_8130_() {
            if (!(this.boss.f_19853_ instanceof ServerLevelAccessor)) {
                return;
            }
            ArrayList targets = new ArrayList();
            targets.addAll(this.boss.getPlayersInDungeonArea());
            for (int i = 0; i < 2; ++i) {
                BlockPos pos = this.boss.m_142538_();
                if (this.boss.isDungeonSpawned()) {
                    pos = this.boss.getHome();
                }
                BlockPos spawnPos = new BlockPos(pos.m_123341_() + -6 + this.boss.f_19796_.nextInt(12), pos.m_123342_(), pos.m_123343_() + -6 + this.boss.f_19796_.nextInt(12));
                ArtificialGolemEntity golem = new ArtificialGolemEntity(this.boss.f_19853_, (LivingEntity)this.boss);
                golem.m_20035_(spawnPos, 0.0f, 0.0f);
                golem.setRanged(true);
                golem.m_6518_((ServerLevelAccessor)this.boss.f_19853_, this.boss.f_19853_.m_6436_(spawnPos), MobSpawnType.MOB_SUMMONED, null, null);
                golem.m_21051_(Attributes.f_22276_).m_22100_(this.boss.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 25.0 : (this.boss.getDifficultyID() == ISkyBoss.BossLevel.GOLD.getId() ? 20.0 : 10.0));
                golem.m_21153_(golem.m_21233_());
                if (this.boss.m_5448_() != null) {
                    golem.m_6710_(this.boss.m_5448_());
                }
                if (!targets.isEmpty()) {
                    Player player = (Player)targets.get(0);
                    golem.m_6710_((LivingEntity)player);
                    targets.remove(0);
                } else if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                    golem.m_6710_((LivingEntity)this.boss.getPlayersInDungeonArea().get(this.boss.f_19853_.f_46441_.nextInt(this.boss.getPlayersInDungeonArea().size())));
                } else if (this.boss.m_5448_() != null) {
                    golem.m_6710_(this.boss.m_5448_());
                }
                golem.m_6710_(this.boss.m_5448_());
                this.boss.f_19853_.m_7967_((Entity)golem);
                if (!(this.boss.f_19853_ instanceof ServerLevel)) continue;
                for (int h = 0; h < 20; ++h) {
                    double dx = this.boss.f_19796_.nextGaussian() * 0.02;
                    double dy = this.boss.f_19796_.nextGaussian() * 0.02;
                    double dz = this.boss.f_19796_.nextGaussian() * 0.02;
                    ((ServerLevel)this.boss.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, golem.m_20185_() + (double)(this.boss.f_19796_.nextFloat() * golem.m_20205_() * 2.0f) - (double)golem.m_20205_(), golem.m_20186_() + (double)(this.boss.f_19796_.nextFloat() * golem.m_20206_()), golem.m_20189_() + (double)(this.boss.f_19796_.nextFloat() * golem.m_20205_() * 2.0f) - (double)golem.m_20205_(), 1, dx, dy, dz, 0.0);
                }
            }
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.SUMMON_RANGED_GOLEM;
        }
    }

    class SummonGolemGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        private SummonGolemGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        @Override
        public boolean m_8036_() {
            int i = this.boss.getGolemsInDungeonArea().size();
            if (i >= this.boss.getMaxGolemsBasedOnPlayerCount()) {
                return false;
            }
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && this.boss.f_19796_.nextInt(8) + 1 > i;
        }

        protected int m_8089_() {
            return 100;
        }

        protected int m_8067_() {
            return 340;
        }

        protected void m_8130_() {
            if (!(this.boss.f_19853_ instanceof ServerLevelAccessor)) {
                return;
            }
            ArrayList targets = new ArrayList();
            targets.addAll(this.boss.getPlayersInDungeonArea());
            int maxGolems = this.boss.getMaxGolemsBasedOnPlayerCount() - this.boss.getGolemsInDungeonArea().size();
            for (int i = 0; i < maxGolems; ++i) {
                BlockPos pos = this.boss.m_142538_();
                if (this.boss.isDungeonSpawned()) {
                    pos = this.boss.getHome();
                }
                BlockPos spawnPos = new BlockPos(pos.m_123341_() + -6 + this.boss.f_19796_.nextInt(12), pos.m_123342_(), pos.m_123343_() + -6 + this.boss.f_19796_.nextInt(12));
                ArtificialGolemEntity golem = new ArtificialGolemEntity(this.boss.f_19853_, (LivingEntity)this.boss);
                golem.m_20035_(spawnPos, 0.0f, 0.0f);
                golem.m_6518_((ServerLevelAccessor)this.boss.f_19853_, this.boss.f_19853_.m_6436_(spawnPos), MobSpawnType.MOB_SUMMONED, null, null);
                if (this.boss.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId()) {
                    golem.m_21051_(Attributes.f_22284_).m_22100_(4.0);
                    double health = this.boss.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 18.0 : 14.0;
                    golem.m_21051_(Attributes.f_22276_).m_22100_(health);
                    golem.m_21153_((float)health);
                }
                if (!targets.isEmpty()) {
                    Player player = (Player)targets.get(0);
                    golem.m_6710_((LivingEntity)player);
                    targets.remove(0);
                } else if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                    golem.m_6710_((LivingEntity)this.boss.getPlayersInDungeonArea().get(this.boss.f_19853_.f_46441_.nextInt(this.boss.getPlayersInDungeonArea().size())));
                } else if (this.boss.m_5448_() != null) {
                    golem.m_6710_(this.boss.m_5448_());
                }
                golem.setEnraged(this.boss.secondPhaseHealth());
                this.boss.f_19853_.m_7967_((Entity)golem);
                if (!(this.boss.f_19853_ instanceof ServerLevel)) continue;
                for (int h = 0; h < 20; ++h) {
                    double dx = this.boss.f_19796_.nextGaussian() * 0.02;
                    double dy = this.boss.f_19796_.nextGaussian() * 0.02;
                    double dz = this.boss.f_19796_.nextGaussian() * 0.02;
                    ((ServerLevel)this.boss.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, golem.m_20185_() + (double)(this.boss.f_19796_.nextFloat() * golem.m_20205_() * 2.0f) - (double)golem.m_20205_(), golem.m_20186_() + (double)(this.boss.f_19796_.nextFloat() * golem.m_20206_()), golem.m_20189_() + (double)(this.boss.f_19796_.nextFloat() * golem.m_20205_() * 2.0f) - (double)golem.m_20205_(), 1, dx, dy, dz, 0.0);
                }
            }
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.SUMMON_GOLEM;
        }
    }

    class SphereAttackGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        private SphereAttackGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0;
        }

        protected int m_8089_() {
            return this.boss.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 50 : 55;
        }

        protected int m_8067_() {
            return 100;
        }

        protected void m_8130_() {
            if (this.boss.m_5448_() != null && this.boss.m_5448_() instanceof LivingEntity) {
                LivingEntity target = this.boss.m_5448_();
                double d0 = Math.min(target.m_20186_(), this.boss.m_20186_());
                double d1 = Math.max(target.m_20186_(), this.boss.m_20186_()) + 0.3;
                float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()));
                if ((double)this.boss.m_20270_((Entity)target) < 5.0 || this.boss.f_19853_.m_45924_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 5.0, true) != null && (double)this.boss.m_20270_((Entity)this.boss.f_19853_.m_45924_(this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 5.0, true)) < 5.0) {
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.spawnLightning(this.boss.m_20185_() + (double)Mth.m_14089_((float)f2) * 4.5, this.boss.m_20189_() + (double)Mth.m_14031_((float)f2) * 4.5, d0, d1, f2, 3);
                    }
                } else {
                    double x = this.boss.m_5448_().m_20185_() - this.boss.m_20185_();
                    double y = this.boss.m_5448_().m_142469_().f_82289_ + (double)(this.boss.m_5448_().m_20206_() / 2.0f) - (this.boss.m_20186_() + (double)(this.boss.m_20206_() / 2.0f));
                    double z = this.boss.m_5448_().m_20189_() - this.boss.m_20189_();
                    this.spawnSphere(x, y, z);
                }
            }
        }

        private void spawnSphere(double posX, double posY, double posZ) {
            LivingEntity target = this.boss.m_5448_();
            if (target != null) {
                Vec3 lookVector = this.boss.m_20252_(1.0f);
                FluctuantSphereEntity projectile = new FluctuantSphereEntity(this.boss.f_19853_, (LivingEntity)this.boss, posX, posY, posZ);
                projectile.m_6034_(this.boss.m_20185_() + lookVector.f_82479_ * 1.0, this.boss.m_20186_() + (double)(this.boss.m_20206_() / 2.0f) + (double)0.2f, this.boss.m_20189_() + lookVector.f_82481_ * 1.0);
                projectile.m_146922_(this.boss.f_20885_);
                this.boss.f_19853_.m_7967_((Entity)projectile);
            }
        }

        private void spawnLightning(double posX, double posZ, double p_190876_5_, double posY, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!this.boss.f_19853_.m_46859_(blockpos) || this.boss.f_19853_.m_46859_(blockpos.m_7495_())) continue;
                if (!this.boss.f_19853_.m_46859_(blockpos) && (voxelshape = (iblockstate = this.boss.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.boss.f_19853_, blockpos)) != null) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
            if (flag) {
                StrangeLightningEntity bolt = new StrangeLightningEntity(this.boss.f_19853_);
                bolt.m_7678_(posX, (double)blockpos.m_123342_() + d0, posZ, 0.0f, 0.0f);
                this.boss.f_19853_.m_7967_((Entity)bolt);
            }
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_ATTACK;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.SPHERE;
        }
    }

    public class RegenGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        public RegenGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && this.boss.secondPhaseHealth();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected void m_8130_() {
            int extraPlayers = Math.min(4, this.boss.getExtraPlayers());
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19605_, (this.boss.getDifficultyID() == ISkyBoss.BossLevel.BRONZE.getId() ? 10 : (this.boss.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 23 : (this.boss.getDifficultyID() >= ISkyBoss.BossLevel.GOLD.getId() ? 21 : 20))) + extraPlayers * 5, 5, false, false));
        }

        protected int m_8069_() {
            return 20;
        }

        protected int m_8089_() {
            return 70;
        }

        protected int m_8067_() {
            int extraPlayers = Math.min(7, this.boss.getExtraPlayers());
            return 340 + extraPlayers * 10;
        }

        protected SoundEvent m_7030_() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_REGEN;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.REGENERATION;
        }
    }
}

