/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.base;

import com.legacy.blue_skies.block_entity.KeystoneBlockEntity;
import com.legacy.blue_skies.data.objects.tags.SkiesBlockTags;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.BossTypePacket;
import com.legacy.blue_skies.network.s_to_c.IllagerTeleportPacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SkiesIllagerBossEntity
extends SpellcasterIllager
implements ISkyBoss {
    public static final EntityDataAccessor<Boolean> DUNGEON_SPAWNED = SynchedEntityData.m_135353_(SkiesIllagerBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> INVULNERABILITY_TIME = SynchedEntityData.m_135353_(SkiesIllagerBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOSS_SPELL_ID = SynchedEntityData.m_135353_(SkiesIllagerBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> RESPAWNED = SynchedEntityData.m_135353_(SkiesIllagerBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> DIFFICULTY_ID = SynchedEntityData.m_135353_(SkiesIllagerBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BossSpellColor activeBossSpell = BossSpellColor.NONE;
    private final ServerBossEvent bossInfo = this.getNewBossInfo();
    protected BlockPos homePos;
    private int teleportCooldown;
    public boolean noLerp = false;
    private static final Vec3i RANGED_GOLEM_SPELL_COLOR = new Vec3i(155, 225, 156);
    private static final Vec3i GOLEM_SPELL_COLOR = new Vec3i(146, 244, 244);
    private static final Vec3i SPHERE_SPELL_COLOR = new Vec3i(51, 53, 94);
    private static final Vec3i ROCKS_SPELL_COLOR = new Vec3i(183, 119, 255);
    private static final Vec3i ARROW_SPELL_COLOR = new Vec3i(177, 157, 106);
    private static final Vec3i POISON_SPELL_COLOR = new Vec3i(59, 123, 49);
    private static final Vec3i HARMING_SPELL_COLOR = new Vec3i(67, 10, 9);
    private static final Vec3i WATER_SPELL_COLOR = new Vec3i(88, 123, 176);
    private static final Vec3i LAVA_SPELL_COLOR = new Vec3i(216, 118, 33);
    private static final Vec3i BLINDNESS_SPELL_COLOR = new Vec3i(31, 31, 35);
    public static final Vec3i REGEN_SPELL_COLOR = new Vec3i(255, 162, 224);

    public SkiesIllagerBossEntity(EntityType<? extends SkiesIllagerBossEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 30;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal());
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DUNGEON_SPAWNED, (Object)false);
        this.f_19804_.m_135372_(INVULNERABILITY_TIME, (Object)0);
        this.f_19804_.m_135372_(BOSS_SPELL_ID, (Object)0);
        this.f_19804_.m_135372_(RESPAWNED, (Object)false);
        this.f_19804_.m_135372_(DIFFICULTY_ID, (Object)1);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData flag = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBossCanJoinRaid(reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.COMMAND);
        if (reason == MobSpawnType.TRIGGERED) {
            this.f_19853_.m_46961_(this.m_142538_(), false);
            this.f_19853_.m_46961_(this.m_142538_().m_7494_(), false);
        }
        if (!this.f_19853_.f_46443_) {
            this.defaultSpawningRoutine(difficultyIn);
        }
        return flag;
    }

    @Override
    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public abstract BlockState getFloorState();

    @OnlyIn(value=Dist.CLIENT)
    public abstract void healthParticles();

    @Override
    public float getMaxReach() {
        return 3.5f;
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.readDefaultBossNBT(compound);
        this.setBossSpellID(compound.m_128451_("BossSpellId"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeDefaultBossNBT(compound);
        compound.m_128405_("BossSpellId", this.getBossSpellID());
    }

    public void m_6478_(MoverType type, Vec3 vec) {
        super.m_6478_(type, this.getInvulTime() > 0 ? new Vec3(0.0, vec.f_82480_, 0.0) : vec);
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossTick();
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.nextDouble() > 0.7) {
                this.healthParticles();
            }
            if (this.m_33736_()) {
                float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
                float f1 = Mth.m_14089_((float)f);
                float f2 = Mth.m_14031_((float)f);
                double d0 = (double)this.getBossSpellType().colorVec.m_123341_() / 255.0;
                double d1 = (double)this.getBossSpellType().colorVec.m_123342_() / 255.0;
                double d2 = (double)this.getBossSpellType().colorVec.m_123343_() / 255.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
            }
        }
        if (!this.f_19853_.f_46443_) {
            List playerCount;
            if (this.m_20069_() || this.m_20077_()) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
            if (this.isDungeonSpawned() && !this.m_21525_()) {
                Player player;
                if (this.getHome() != null) {
                    this.checkIfHome();
                }
                if (this.m_5448_() instanceof Player && !(player = (Player)this.m_5448_()).m_6084_()) {
                    this.m_6021_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_());
                }
                ++this.teleportCooldown;
            }
            if (this.m_5448_() != null && ((playerCount = this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_(4.0))).size() > 0 && this.m_5448_() instanceof Player || (double)this.m_20270_((Entity)this.m_5448_()) <= 5.0)) {
                this.teleportAround();
            }
        }
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        if (this.noLerp) {
            this.f_20903_ = 0;
            this.m_6034_(pX, pY, pZ);
            this.m_19915_(pYaw, pPitch);
            this.noLerp = false;
            return;
        }
        super.m_6453_(pX, pY, pZ, pYaw, pPitch, pPosRotationIncrements, pTeleport);
    }

    public void m_6021_(double pX, double pY, double pZ) {
        super.m_6021_(pX, pY, pZ);
        this.sendNoLerp();
    }

    protected void sendNoLerp() {
        this.getPlayersInDungeonArea().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PacketHandler.sendToClient(new IllagerTeleportPacket(this.m_142049_()), sp);
            }
        });
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.onBossDeath(source);
        if (!this.f_19853_.f_46443_ && this.isDungeonSpawned() && this.getHome() != null) {
            this.f_19853_.m_7731_(this.getHome().m_7494_(), this.isEverbrightBoss() ? SkiesBlocks.bright_blinding_keystone.m_49966_() : SkiesBlocks.dawn_blinding_keystone.m_49966_(), 2);
            this.f_19853_.m_46597_(this.getHome(), SkiesBlocks.blinding_stone.m_49966_());
            BlockEntity keystone = this.f_19853_.m_7702_(this.getHome().m_7494_());
            if (keystone instanceof KeystoneBlockEntity) {
                ((KeystoneBlockEntity)keystone).setTeleportOffset(new BlockPos(0, -9, 5));
                ((KeystoneBlockEntity)keystone).setSpawnsBoss(false);
                ((KeystoneBlockEntity)keystone).setKeysRequired(false);
            }
        }
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), EntityUtil.makeFirework((DyeColor)this.getFireworkColors().getLeft(), 0, (DyeColor)this.getFireworkColors().getRight()));
        this.f_19853_.m_7967_((Entity)fireworkrocketentity);
    }

    public abstract Pair<DyeColor, DyeColor> getFireworkColors();

    protected void m_8024_() {
        if (this.getInvulTime() <= 0) {
            super.m_8024_();
            if (this.m_5448_() == null && this.isDungeonSpawned() && this.teleportCooldown >= 40 && this.f_19796_.nextFloat() * 120.0f < 4.6f) {
                this.teleportAround();
                this.teleportCooldown = 0;
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || this.getInvulTime() > 0 && source != DamageSource.f_19317_ || source == DamageSource.f_19306_ || source.m_19360_() && source.m_7639_() == this) {
            return false;
        }
        if (source.m_19360_() && (source.m_7639_() instanceof SpellcasterIllager || source.m_7639_() instanceof ArtificialGolemEntity) || source.m_19360_() && !this.m_33736_()) {
            if (this.f_19853_.f_46443_) {
                return false;
            }
            this.teleportAround();
            return false;
        }
        if (source.m_7640_() instanceof Player) {
            Player player = (Player)source.m_7640_();
            ItemStack stack = player.m_150109_().m_36056_();
            if (source.m_19390_()) {
                return super.m_6469_(source, amount);
            }
            if (stack.m_41720_() == SkiesItems.debug_sword) {
                return false;
            }
            if ((source.m_19360_() || source.m_19387_()) && source.m_7639_() == null || !source.m_19360_() && source.m_7639_() != null && source.m_7639_().m_20270_((Entity)this) > 3.55f) {
                return false;
            }
            return super.m_6469_(source, Math.min((float)this.getDamageCap(), amount));
        }
        return super.m_6469_(source, amount);
    }

    public void teleportAround() {
        if (!this.f_19853_.f_46443_ && !this.m_33736_() && this.getInvulTime() <= 0) {
            double d0 = this.m_20185_();
            double d1 = this.m_20186_();
            double d2 = this.m_20189_();
            double teleportStartX = this.isDungeonSpawned() ? (double)this.getHome().m_123341_() : this.m_20185_();
            double teleportStartY = this.isDungeonSpawned() ? (double)this.getHome().m_123342_() : this.m_20186_();
            double teleportStartZ = this.isDungeonSpawned() ? (double)this.getHome().m_123343_() : this.m_20189_();
            for (int i = 0; i < 24; ++i) {
                boolean canTeleport;
                double d3 = teleportStartX + (this.m_21187_().nextDouble() - 0.5) * 15.0;
                double d4 = Mth.m_14008_((double)(teleportStartY + (double)(this.m_21187_().nextInt(16) - 8)), (double)0.0, (double)(this.f_19853_.m_151558_() - 1));
                double d5 = teleportStartZ + (this.m_21187_().nextDouble() - 0.5) * 15.0;
                if (this.m_20202_() != null) {
                    this.m_8127_();
                }
                boolean bl = canTeleport = this.isDungeonSpawned() ? this.attemptDungeonTeleport(d3, Math.floor(d4), d5) : this.m_20984_(d3, Math.floor(d4), d5, true);
                if (!canTeleport) continue;
                this.f_19853_.m_6263_((Player)null, d0, d1, d2, SoundEvents.f_11757_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                break;
            }
        }
        this.f_19864_ = true;
    }

    public boolean attemptDungeonTeleport(double x, double y, double z) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel world = (ServerLevel)level;
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        double d3 = y;
        boolean flag = false;
        BlockPos blockpos = new BlockPos(x, y, z);
        if (world.m_46749_(blockpos)) {
            boolean shouldCompleteTeleport = false;
            while (!shouldCompleteTeleport && blockpos.m_123342_() > 0) {
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = world.m_8055_(blockpos1);
                AABB bounds = new AABB(blockpos).m_82377_(0.5, 0.0, 0.5);
                if (blockstate.m_204336_(SkiesBlockTags.ILLAGER_TELEPORTABLE) && this.f_19853_.m_45924_((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_(), 6.0, true) == null && blockstate.m_60767_().m_76334_() && this.f_19853_.m_45772_(bounds) && !world.m_46855_(bounds)) {
                    shouldCompleteTeleport = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (shouldCompleteTeleport) {
                float width = this.m_20205_() / 2.0f;
                float height = this.m_20206_() * 0.3f;
                world.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + (double)height, this.m_20189_(), 40, (double)width, (double)height, (double)width, 0.0);
                BlockPos teleportationPos = new BlockPos(x, d3, z);
                this.m_6021_(teleportationPos.m_123341_(), teleportationPos.m_123342_(), teleportationPos.m_123343_());
                flag = true;
                world.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + (double)height, this.m_20189_(), 40, (double)width, (double)height, (double)width, 0.0);
            }
        }
        if (!flag) {
            this.m_6021_(d0, d1, d2);
            return false;
        }
        this.m_21573_().m_26573_();
        return true;
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn instanceof Vex) {
            return this.m_7307_((Entity)((Vex)entityIn).m_34026_());
        }
        if (entityIn instanceof DecayingSpikeEntity) {
            return this.m_7307_((Entity)((DecayingSpikeEntity)entityIn).getCaster());
        }
        if (entityIn instanceof ArtificialGolemEntity) {
            return this.m_7307_((Entity)((ArtificialGolemEntity)entityIn).getCaster());
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) || entityIn == this;
    }

    public void checkIfHome() {
        if (this.getHome() == null || !this.isDungeonSpawned()) {
            return;
        }
        int distance = 22;
        if (EntityUtil.getDistanceToPos((Vec3i)this.m_142538_(), (Vec3i)this.getHome()) >= (float)distance || this.m_20186_() < (double)(this.getHome().m_123342_() - 2)) {
            this.m_6021_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_());
            this.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
            this.m_21373_();
            this.f_19853_.m_46597_(this.getHome().m_7495_(), this.getFloorState());
        }
    }

    public void setBossSpellType(BossSpellColor spellType) {
        this.activeBossSpell = spellType;
        this.setBossSpellID(spellType.id);
    }

    protected BossSpellColor getBossSpellType() {
        return !this.f_19853_.f_46443_ ? this.activeBossSpell : BossSpellColor.getFromId((Integer)this.f_19804_.m_135370_(BOSS_SPELL_ID));
    }

    public void m_37897_(boolean canJoinIn) {
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void setBossCanJoinRaid(boolean canJoinIn) {
        super.m_37897_(canJoinIn);
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean secondPhaseHealth() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    @Override
    public int getExtraPlayers() {
        return Math.max(0, this.getPlayersInDungeonArea().size() - 1);
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.getBossInfo().m_6456_((Component)this.m_5446_().m_6879_().m_7220_(ISkyBoss.getDifficultyDecoration(this.getDifficultyID())));
    }

    @Override
    public BlockPos getHome() {
        if (this.homePos != null && !this.homePos.equals((Object)BlockPos.f_121853_)) {
            return this.homePos;
        }
        return this.m_142538_();
    }

    @Override
    public boolean isDungeonSpawned() {
        return (Boolean)this.f_19804_.m_135370_(DUNGEON_SPAWNED);
    }

    @Override
    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.f_19804_.m_135381_(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    @Override
    public void setHome(BlockPos pos) {
        this.homePos = pos;
    }

    @Override
    public int getInvulTime() {
        return (Integer)this.f_19804_.m_135370_(INVULNERABILITY_TIME);
    }

    @Override
    public void setInvulTime(int time) {
        this.f_19804_.m_135381_(INVULNERABILITY_TIME, (Object)time);
    }

    public int getBossSpellID() {
        return (Integer)this.f_19804_.m_135370_(BOSS_SPELL_ID);
    }

    public void setBossSpellID(int id) {
        this.f_19804_.m_135381_(BOSS_SPELL_ID, (Object)id);
    }

    @Override
    public byte getDifficultyID() {
        return (Byte)this.f_19804_.m_135370_(DIFFICULTY_ID);
    }

    @Override
    public void setDifficultyID(byte id) {
        this.f_19804_.m_135381_(DIFFICULTY_ID, (Object)((byte)Math.min(3, id)));
    }

    @Override
    public boolean isBossRespawned() {
        return (Boolean)this.f_19804_.m_135370_(RESPAWNED);
    }

    @Override
    public void setBossRespawned(boolean isRespawned) {
        this.f_19804_.m_135381_(RESPAWNED, (Object)isRespawned);
    }

    public void m_6457_(ServerPlayer player) {
        PacketHandler.sendToClient(new BossTypePacket((byte)this.getBossType().getId()), player);
        super.m_6457_(player);
        this.getBossInfo().m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.getBossInfo().m_6539_(player);
    }

    public boolean isAwayFromPlayers() {
        Player player = this.f_19853_.m_45924_((double)this.m_142538_().m_123341_(), (double)this.m_142538_().m_123342_(), (double)this.m_142538_().m_123343_(), 5.0, true);
        return this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) >= 5.0 && player == null || player == null;
    }

    public boolean m_33067_() {
        return super.m_33067_() && !this.isDungeonSpawned();
    }

    @Override
    public Monster getBoss() {
        return this;
    }

    public static enum BossSpellColor implements IExtensibleEnum
    {
        NONE(0, Vec3i.f_123288_),
        REGENERATION(1, REGEN_SPELL_COLOR),
        SUMMON_GOLEM(2, GOLEM_SPELL_COLOR),
        SUMMON_RANGED_GOLEM(3, RANGED_GOLEM_SPELL_COLOR),
        SPHERE(4, SPHERE_SPELL_COLOR),
        ROCKS(5, ROCKS_SPELL_COLOR),
        ARROW_BUNDLE(6, ARROW_SPELL_COLOR),
        POISON_CLOUD(7, POISON_SPELL_COLOR),
        HARMING_CLOUD(8, HARMING_SPELL_COLOR),
        WATER(9, WATER_SPELL_COLOR),
        LAVA(10, LAVA_SPELL_COLOR),
        BLINDNESS(11, BLINDNESS_SPELL_COLOR);

        public final Vec3i colorVec;
        public final int id;

        private BossSpellColor(int id, Vec3i colorVec) {
            this.colorVec = colorVec;
            this.id = id;
        }

        public static BossSpellColor getFromId(int idIn) {
            for (BossSpellColor bossTypes : BossSpellColor.values()) {
                if (idIn != bossTypes.id) continue;
                return bossTypes;
            }
            return NONE;
        }

        public static BossSpellColor create(String enumName, int id, Vec3i colorVec) {
            throw new IllegalStateException("Enum not extended");
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SkiesIllagerBossEntity.this.getInvulTime() > 0;
        }
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        private SkiesIllagerBossEntity boss;

        private CastingSpellGoal() {
            super((SpellcasterIllager)SkiesIllagerBossEntity.this);
            this.boss = SkiesIllagerBossEntity.this;
        }

        public void m_8056_() {
            super.m_8056_();
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (Player players : playersInDungeon) {
                if (players == this.boss.m_5448_() || !SkiesIllagerBossEntity.this.f_19796_.nextBoolean() || playersInDungeon.size() <= 1 || players.m_7500_() || players.m_5833_()) continue;
                this.boss.m_6710_((LivingEntity)players);
                break;
            }
        }

        public void m_8037_() {
            if (this.boss.m_5448_() != null) {
                this.boss.m_21563_().m_24960_((Entity)this.boss.m_5448_(), (float)this.boss.m_8085_(), (float)this.boss.m_8132_());
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public abstract class UseBossSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        protected UseBossSpellGoal() {
            super((SpellcasterIllager)SkiesIllagerBossEntity.this);
        }

        protected abstract BossSpellColor getSpellColor();

        public void m_8056_() {
            super.m_8056_();
            SkiesIllagerBossEntity.this.setBossSpellType(this.getSpellColor());
        }

        public boolean m_183429_() {
            return true;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }
}

