/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.legacy.blue_skies.blocks.SkyPortalBlock;
import com.legacy.blue_skies.blocks.misc.SkyFireBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.api.dimension.portal.GelPortalLogic;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.portal.PortalShape;

public class ZealLighterItem
extends FlintAndSteelItem {
    public ZealLighterItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockState placePos = level.m_8055_(pos = context.m_8083_());
        if (CampfireBlock.m_51321_((BlockState)placePos)) {
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
            level.m_7731_(pos, (BlockState)placePos.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            if (player != null) {
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockPos offsetPos = pos.m_142300_(context.m_43719_());
        if (ZealLighterItem.canLightBlock(level, offsetPos, context.m_8125_())) {
            level.m_5594_(player, offsetPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
            BlockState fireState = ZealLighterItem.getFire(level, offsetPos).m_60734_().m_5573_(new BlockPlaceContext(context));
            level.m_7731_(offsetPos, fireState, 11);
            ItemStack stack = context.m_43722_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_59469_(serverPlayer, offsetPos, stack);
                stack.m_41622_(1, (LivingEntity)serverPlayer, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    public static boolean canLightBlock(Level world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60767_() != Material.f_76296_) {
            return false;
        }
        BlockState fire = ZealLighterItem.getFire(world, pos);
        return fire.m_60710_((LevelReader)world, pos) || ZealLighterItem.shouldLightNetherPortal(world, pos, facing) || fire.m_60734_() instanceof SkyFireBlock && GelPortalLogic.getPortalFrame((Level)world, (BlockPos)pos, (GelPortalBlock)((SkyFireBlock)fire.m_60734_()).portalBlock.get(), SkyPortalBlock.ALLOWED_INSIDE_BLOCKS) != null;
    }

    public static BlockState getFire(Level world, BlockPos pos) {
        ResourceKey type = world.m_46472_();
        if (SoulFireBlock.m_154650_((BlockState)world.m_8055_(pos.m_7495_()))) {
            return Blocks.f_50084_.m_49966_();
        }
        if (type == SkiesDimensions.everbrightKey() || type == Level.f_46428_ && GelPortalLogic.getPortalFrame((Level)world, (BlockPos)pos, (GelPortalBlock)SkiesBlocks.everbright_portal, SkyPortalBlock.ALLOWED_INSIDE_BLOCKS) != null) {
            return SkiesBlocks.blue_fire.m_49966_();
        }
        if (type == SkiesDimensions.everdawnKey() || type == Level.f_46428_ && GelPortalLogic.getPortalFrame((Level)world, (BlockPos)pos, (GelPortalBlock)SkiesBlocks.everdawn_portal, SkyPortalBlock.ALLOWED_INSIDE_BLOCKS) != null) {
            return SkiesBlocks.black_fire.m_49966_();
        }
        return BaseFireBlock.m_49245_((BlockGetter)world, (BlockPos)pos);
    }

    private static boolean shouldLightNetherPortal(Level world, BlockPos pos, Direction facing) {
        if (world.m_46472_() != Level.f_46428_ && world.m_46472_() != Level.f_46429_) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        boolean flag = false;
        for (Direction direction : Direction.values()) {
            if (!world.m_8055_((BlockPos)mutablePos.m_122190_((Vec3i)pos).m_122173_(direction)).m_60713_(Blocks.f_50080_)) continue;
            flag = true;
            break;
        }
        return flag && PortalShape.m_77708_((LevelAccessor)world, (BlockPos)pos, (Direction.Axis)facing.m_122428_().m_122434_()).isPresent();
    }
}

