/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SkiesSurfaceRules
extends SurfaceRules {
    public static RandomConditionSource randomBoolean(String name) {
        return new RandomConditionSource(BlueSkies.locate(name));
    }

    public record RandomConditionSource(ResourceLocation randomName) implements SurfaceRules.ConditionSource
    {
        public static final Codec<RandomConditionSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("random_name").forGetter(RandomConditionSource::randomName)).apply((Applicative)instance, RandomConditionSource::new));

        public SurfaceRules.Condition apply(SurfaceRules.Context context) {
            PositionalRandomFactory positionalrandomfactory = context.f_189535_.m_189988_(this.randomName());
            RandomSource randomsource = positionalrandomfactory.m_183161_(context.f_189546_, 0, context.f_189547_);
            return new RandomCondition(randomsource);
        }

        public Codec<? extends SurfaceRules.ConditionSource> m_183284_() {
            return CODEC;
        }

        class RandomCondition
        implements SurfaceRules.Condition {
            private final RandomSource source;

            public RandomCondition(RandomSource randomSource) {
                this.source = randomSource;
            }

            public boolean m_183475_() {
                return this.source.nextBoolean();
            }
        }
    }

    public static enum ReservoirMuddiness implements SurfaceRules.RuleSource
    {
        INSTANCE;

        public static final Codec<ReservoirMuddiness> CODEC;

        public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            return (x, y, z) -> this.getBlocks(x, y, z, context);
        }

        protected BlockState getBlocks(int x, int y, int z, SurfaceRules.Context context) {
            double noise = context.f_189535_.m_189983_(Noises.f_189256_).m_75380_((double)x, 0.0, (double)z);
            RandomSource rand = context.f_189535_.m_189988_(BlueSkies.locate("reservoir_mud")).m_183161_(x, 0, z);
            double mudRange = 0.55;
            if (noise < mudRange / 8.25 && noise > -mudRange / 8.25 && rand.nextFloat() < 0.8f) {
                return SkiesBlocks.lunar_mud.m_49966_();
            }
            if (noise < (mudRange + (double)0.7f) / 8.25 && noise > -(mudRange + (double)0.7f) / 8.25 && rand.nextBoolean()) {
                return SkiesBlocks.coarse_lunar_dirt.m_49966_();
            }
            return SkiesBlocks.lunar_grass_block.m_49966_();
        }

        static {
            CODEC = Codec.unit((Object)((Object)INSTANCE));
        }
    }

    public static enum CrystalRoughness implements SurfaceRules.RuleSource
    {
        INSTANCE;

        public static final Codec<CrystalRoughness> CODEC;

        public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            return (x, y, z) -> this.getBlocks(x, y, z, context);
        }

        protected BlockState getBlocks(int x, int y, int z, SurfaceRules.Context context) {
            RandomSource rand;
            double noise = context.f_189535_.m_189983_(Noises.f_189256_).m_75380_((double)x, 0.0, (double)z);
            if (noise > (1.0 + (double)(rand = context.f_189535_.m_189988_(BlueSkies.locate("roughs_crystallization")).m_183161_(x, 0, z)).nextInt(2)) / 8.25 || noise < 0.0 && noise > -0.18181818181818182 && rand.nextBoolean()) {
                return SkiesBlocks.crystal_sand.m_49966_();
            }
            return SkiesBlocks.lunar_grass_block.m_49966_();
        }

        static {
            CODEC = Codec.unit((Object)((Object)INSTANCE));
        }
    }
}

