/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.BaseLargeMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class SnowcapMushroomFeature
extends BaseLargeMushroomFeature {
    private static final BlockState STEM = SkiesBlocks.snowcap_mushroom_stem.m_49966_();
    private static final BlockState CAP = SkiesBlocks.snowcap_mushroom_block.m_49966_();

    public SnowcapMushroomFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    @Override
    public boolean place(WorldGenLevel world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedMushrooms) {
        Direction[] directionArray;
        int bottomOffset;
        int capWidth = rand.nextBoolean() ? 3 : 4;
        int height = 10 + rand.nextInt(4);
        if (!this.isAreaOk(world, pos, height, 1, height, capWidth * 2 + 1)) {
            return false;
        }
        if (world.m_8055_(pos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_)) {
            for (bottomOffset = 0; bottomOffset < 2 && world.m_8055_(pos.m_6625_(bottomOffset + 1)).m_60819_().m_205070_(FluidTags.f_13131_); ++bottomOffset) {
            }
        }
        for (int y = -bottomOffset; y < height; ++y) {
            this.setBlockIfOk(changedMushrooms, world, pos.m_6630_(y), STEM);
        }
        Direction[] y = DirectionUtil.HORIZONTAL;
        int n = y.length;
        for (int i = 0; i < n; ++i) {
            BlockState lowerState;
            Direction dir = y[i];
            BlockPos offsetPos = pos.m_142300_(dir).m_6625_(bottomOffset);
            this.setBlockIfOk(changedMushrooms, world, offsetPos, STEM);
            if (rand.nextBoolean()) {
                this.setBlockIfOk(changedMushrooms, world, offsetPos.m_7494_(), STEM);
            }
            if (!(lowerState = world.m_8055_(offsetPos.m_7495_())).m_60767_().m_76336_() && !(lowerState.m_60734_() instanceof BushBlock)) continue;
            this.setBlock(changedMushrooms, world, offsetPos.m_7495_(), STEM);
        }
        for (int x = -capWidth; x <= capWidth; ++x) {
            for (int z = -capWidth; z <= capWidth; ++z) {
                if (Math.abs(x) == capWidth && Math.abs(x) == Math.abs(z)) continue;
                this.setBlockIfOk(changedMushrooms, world, pos.m_142082_(x, height, z), (BlockState)CAP.m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)));
            }
        }
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            for (int i = -capWidth; i <= capWidth; ++i) {
                BlockState state = (BlockState)((BlockState)CAP.m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55154_.get(dir.m_122424_().m_122427_()), (Comparable)Boolean.valueOf(false));
                if (Math.abs(i) == capWidth - 1) {
                    state = (BlockState)((BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(dir), (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55154_.get(dir.m_122424_()), (Comparable)Boolean.valueOf(false));
                }
                this.setBlockIfOk(changedMushrooms, world, pos.m_5484_(dir, i).m_5484_(dir.m_122427_(), i > -capWidth + 1 && i < capWidth - 1 ? capWidth + 1 : capWidth).m_6630_(height - 1), state);
            }
        }
        Direction.AxisDirection lowerSide = rand.nextBoolean() ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        int baseBranchHeight = height - 5 - rand.nextInt(2);
        if (rand.nextBoolean()) {
            Direction[] directionArray2 = new Direction[2];
            directionArray2[0] = Direction.NORTH;
            directionArray = directionArray2;
            directionArray2[1] = Direction.SOUTH;
        } else {
            Direction[] directionArray3 = new Direction[2];
            directionArray3[0] = Direction.EAST;
            directionArray = directionArray3;
            directionArray3[1] = Direction.WEST;
        }
        for (Direction dir : directionArray) {
            int y2 = baseBranchHeight;
            if (dir.m_122421_() == lowerSide) {
                y2 = Math.max(y2 - rand.nextInt(2) - 2, 2);
            }
            int branchLength = 2;
            for (int i = 1; i <= branchLength; ++i) {
                this.setBlockIfOk(changedMushrooms, world, pos.m_5484_(dir, i).m_6630_(y2), STEM);
            }
            BlockPos branchCapPos = pos.m_5484_(dir, rand.nextBoolean() ? branchLength : branchLength + 1);
            this.setBlockIfOk(changedMushrooms, world, branchCapPos.m_6630_(y2 + 1), STEM);
            int branchCapWidth = 1;
            for (int x = -branchCapWidth; x <= branchCapWidth; ++x) {
                for (int z = -branchCapWidth; z <= branchCapWidth; ++z) {
                    this.setBlockIfOk(changedMushrooms, world, branchCapPos.m_142082_(x, y2 + 2, z), (BlockState)CAP.m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidGround(WorldGenLevel world, BlockState state, BlockPos pos) {
        if (!super.isValidGround(world, state, pos)) {
            if (world.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_)) {
                int depth;
                for (depth = 0; depth <= 2 && world.m_8055_(pos.m_6625_(depth)).m_60819_().m_205070_(FluidTags.f_13131_); ++depth) {
                }
                if (depth <= 2) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

