/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features.cave;

import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveSpawnerFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EverdawnCaveSpawnerFeature
extends AbstractCaveSpawnerFeature {
    public EverdawnCaveSpawnerFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec, new Simple(), new SpiderNest(), new Moonstone());
    }

    private static class Simple
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Simple() {
            super(SkiesEntityTypes.INFESTED_SWARMER, "everdawn_simple");
        }

        @Override
        @Nullable
        public BlockState modifyState(ServerLevelAccessor world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.m_60734_() == SkiesBlocks.lunar_stonebrick && rand.nextFloat() < 0.64f) {
                return SkiesBlocks.cracked_lunar_stonebrick.m_49966_();
            }
            if (originalState.m_60734_() == SkiesBlocks.lunar_stonebrick_stairs && rand.nextFloat() < 0.5f) {
                return (BlockState)((BlockState)((BlockState)((BlockState)SkiesBlocks.cracked_lunar_stonebrick_stairs.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)originalState.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)originalState.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)originalState.m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)StairBlock.f_56844_, (Comparable)((Boolean)originalState.m_61143_((Property)StairBlock.f_56844_)));
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERDAWN_CAVE_SPAWNER;
        }
    }

    private static class SpiderNest
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public SpiderNest() {
            super(SkiesEntityTypes.VENOM_SPIDER, "everdawn_spider_nest");
        }

        @Override
        @Nullable
        public BlockState modifyState(ServerLevelAccessor world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.m_60734_() == SkiesBlocks.lunar_mud && rand.nextFloat() < 0.35f) {
                return SkiesBlocks.coarse_lunar_dirt.m_49966_();
            }
            if (originalState.m_60734_() == SkiesBlocks.spider_webbing && rand.nextFloat() < 0.4f) {
                return Blocks.f_50016_.m_49966_();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERDAWN_CAVE_SPAWNER;
        }
    }

    private static class Moonstone
    extends AbstractCaveSpawnerFeature.SpawnerTemplateData {
        public Moonstone() {
            super(SkiesEntityTypes.INFESTED_SWARMER, "everdawn_moonstone");
        }

        @Override
        @Nullable
        public BlockState modifyState(ServerLevelAccessor world, Random rand, BlockPos pos, BlockState originalState) {
            if (originalState.m_60734_() == SkiesBlocks.lunar_stone && rand.nextFloat() < 0.1f) {
                return SkiesBlocks.lunar_cobblestone.m_49966_();
            }
            return originalState;
        }

        @Override
        protected ResourceLocation getLoot() {
            return SkiesLootProv.EVERDAWN_CAVE_SPAWNER;
        }
    }
}

